/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.transformation;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Pattern;

public record ProcessorName(String namespace, String path) implements Comparable<ProcessorName>
{
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("^[a-z0-9_.-]+$");
    private static final Pattern PATH_PATTERN = Pattern.compile("^[a-z0-9_./-]+$");

    public ProcessorName {
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(path, "path");
        if (!NAMESPACE_PATTERN.asMatchPredicate().test(namespace)) {
            throw new IllegalArgumentException("Invalid namespace for processor name: " + namespace);
        }
        if (!PATH_PATTERN.asMatchPredicate().test(path)) {
            throw new IllegalArgumentException("Invalid path for processor name: " + path);
        }
    }

    @Override
    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public static ProcessorName parse(String fullName) {
        String[] parts = fullName.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid processor name: " + fullName);
        }
        return new ProcessorName(parts[0], parts[1]);
    }

    @Override
    public int compareTo(ProcessorName other) {
        return Comparator.comparing(ProcessorName::namespace).thenComparing(ProcessorName::path).compare(this, other);
    }
}

