/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.util.PathPrettyPrinting;
import net.neoforged.jarjar.selection.JarSelector;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import net.neoforged.neoforgespi.locating.ModFileLoadingException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class JarInJarDependencyLocator
implements IDependencyLocator {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public void scanMods(List<IModFile> loadedMods, IDiscoveryPipeline pipeline) {
        HashMap createdModFiles = new HashMap();
        List dependenciesToLoad = JarSelector.detectAndSelect(loadedMods, this::loadResourceFromModFile, (file, path) -> this.loadModFileFrom((IModFile)file, (String)path, pipeline, createdModFiles), this::identifyMod, this::exception);
        if (dependenciesToLoad.isEmpty()) {
            LOGGER.info("No dependencies to load found. Skipping!");
        } else {
            LOGGER.info("Found {} dependencies adding them to mods collection", (Object)dependenciesToLoad.size());
            for (IModFile modFile : dependenciesToLoad) {
                if (pipeline.addModFile(modFile)) continue;
                ((ModFile)modFile).close();
            }
        }
    }

    private Optional<IModFile> loadModFileFrom(IModFile file, String relativePath, IDiscoveryPipeline pipeline, Map<EmbeddedJarKey, IModFile> createdModFiles) {
        EmbeddedJarKey key = new EmbeddedJarKey(file, relativePath);
        IModFile innerModFile = createdModFiles.computeIfAbsent(key, ignored -> {
            JarContents jar;
            Path finalPath;
            Path tempFile;
            Path jijCacheDir = FMLPaths.JIJ_CACHEDIR.get();
            try {
                tempFile = Files.createTempFile(jijCacheDir, "_jij", ".tmp", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ModFileLoadingException("Failed to create a temporary file for JIJ in " + String.valueOf(jijCacheDir) + ": " + String.valueOf(e));
            }
            try {
                String checksum = JarInJarDependencyLocator.extractEmbeddedJarFile(file, relativePath, tempFile);
                String filename = relativePath.substring(relativePath.lastIndexOf(47) + 1);
                finalPath = jijCacheDir.resolve(checksum + "/" + filename);
                if (!Files.isRegularFile(finalPath, new LinkOption[0])) {
                    JarInJarDependencyLocator.moveExtractedFileIntoPlace(tempFile, finalPath);
                    PathPrettyPrinting.addSubstitution(finalPath, PathPrettyPrinting.prettyPrint(file.getFilePath()) + " > " + filename, "");
                }
            }
            finally {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to remove temporary file {}: {}", (Object)tempFile, (Object)e);
                }
            }
            try {
                jar = JarContents.ofPath(finalPath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read Jar-in-Jar file {} extracted from mod file {} to {}", new Object[]{relativePath, file, finalPath, e});
                throw new ModFileLoadingException("Failed to load mod file " + relativePath + " from " + String.valueOf(file), e);
            }
            return pipeline.readModFile(jar, ModFileDiscoveryAttributes.DEFAULT.withParent(file));
        });
        return Optional.ofNullable(innerModFile);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String extractEmbeddedJarFile(IModFile file, String relativePath, Path destination) {
        try (InputStream inStream = file.getContents().openFile(relativePath);){
            String string;
            block17: {
                OutputStream outStream = Files.newOutputStream(destination, new OpenOption[0]);
                try {
                    MessageDigest digest;
                    if (inStream == null) {
                        LOGGER.error("Mod file {} declares Jar-in-Jar {} but does not contain it.", (Object)file, (Object)relativePath);
                        throw new ModFileLoadingException("Mod file " + String.valueOf(file) + " declares Jar-in-Jar " + relativePath + " but does not contain it.");
                    }
                    try {
                        digest = MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Missing default JCA algorithm SHA-256.", e);
                    }
                    DigestOutputStream digestOut = new DigestOutputStream(outStream, digest);
                    inStream.transferTo(digestOut);
                    string = HexFormat.of().formatHex(digest.digest());
                    if (outStream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outStream.close();
            }
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Failed to copy Jar-in-Jar file {} from mod file {} to {}", new Object[]{relativePath, file, destination, e});
            throw new ModFileLoadingException("Failed to load mod file " + file.getFileName(), e);
        }
    }

    private static void moveExtractedFileIntoPlace(Path source, Path destination) {
        try {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create parent directory for extracted JiJ-file " + String.valueOf(source) + " at " + String.valueOf(destination), e);
        }
        try {
            try {
                Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (AtomicMoveNotSupportedException ex) {
                Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to move temporary JiJ-file " + String.valueOf(source) + " to its final location " + String.valueOf(destination), e);
        }
    }

    private ModLoadingException exception(Collection<JarSelector.ResolutionFailureInformation<IModFile>> failedDependencies) {
        List<ModLoadingIssue> errors = failedDependencies.stream().filter(entry -> !entry.sources().isEmpty()).map(this::buildExceptionData).toList();
        return new ModLoadingException(errors);
    }

    private ModLoadingIssue buildExceptionData(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        String artifact = entry.identifier().group() + ":" + entry.identifier().artifact();
        String requestedBy = entry.sources().stream().flatMap(this::getModWithVersionRangeStream).map(this::formatError).collect(Collectors.joining(", "));
        return ModLoadingIssue.error(this.getErrorTranslationKey(entry), artifact, requestedBy);
    }

    private String getErrorTranslationKey(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return entry.failureReason() == JarSelector.FailureReason.VERSION_RESOLUTION_FAILED ? "fml.modloadingissue.dependencyloading.conflictingdependencies" : "fml.modloadingissue.dependencyloading.mismatchedcontaineddependencies";
    }

    private Stream<ModWithVersionRange> getModWithVersionRangeStream(JarSelector.SourceWithRequestedVersionRange<IModFile> file) {
        return file.sources().stream().map(IModFile::getModFileInfo).flatMap(modFileInfo -> modFileInfo.getMods().stream()).map(modInfo -> new ModWithVersionRange((IModInfo)modInfo, file.requestedVersionRange(), file.includedVersion()));
    }

    private String formatError(ModWithVersionRange modWithVersionRange) {
        return "\u00a7e" + modWithVersionRange.modInfo().getModId() + "\u00a7r - \u00a74" + modWithVersionRange.versionRange().toString() + "\u00a74 - \u00a72" + modWithVersionRange.artifactVersion().toString() + "\u00a72";
    }

    private String identifyMod(IModFile modFile) {
        if (modFile.getModFileInfo() == null) {
            return modFile.getFileName();
        }
        if (modFile.getModInfos().isEmpty()) {
            return "library:" + modFile.getId();
        }
        return modFile.getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining());
    }

    private Optional<InputStream> loadResourceFromModFile(IModFile modFile, String relativePath) {
        try {
            return Optional.ofNullable(modFile.getContents().openFile(relativePath));
        }
        catch (NoSuchFileException e) {
            LOGGER.trace("Failed to load resource {} from {}, it does not contain dependency information.", (Object)relativePath, (Object)modFile.getFileName());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load resource {} from mod {}, cause {}", new Object[]{relativePath, modFile.getFileName(), e});
            return Optional.empty();
        }
    }

    public String toString() {
        return "jarinjar";
    }

    record EmbeddedJarKey(IModFile modFile, String relativePath) {
    }

    private record ModWithVersionRange(IModInfo modInfo, VersionRange versionRange, ArtifactVersion artifactVersion) {
    }
}

