/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.UniqueModListBuilder;
import net.neoforged.fml.loading.VersionSupportMatrix;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.fml.loading.toposort.CyclePresentException;
import net.neoforged.fml.loading.toposort.TopologicalSort;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.slf4j.Logger;

class ModSorter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final UniqueModListBuilder uniqueModListBuilder;
    private List<ModFile> modFiles;
    private List<ModInfo> sortedList;
    private Map<ModInfo, List<ModInfo>> modDependencies;
    private Map<String, IModInfo> modIdNameLookup;
    private List<ModFile> systemMods;

    private ModSorter(List<ModFile> modFiles) {
        this.uniqueModListBuilder = new UniqueModListBuilder(modFiles);
    }

    public static LoadingModList sort(List<ModFile> modFiles, List<ModLoadingIssue> issues) {
        ArrayList<ModFile> gameContent = new ArrayList<ModFile>(modFiles.size());
        ArrayList<ModFile> gameLibraryContent = new ArrayList<ModFile>(modFiles.size());
        ArrayList<ModFile> pluginContent = new ArrayList<ModFile>(modFiles.size());
        for (ModFile modFile : modFiles) {
            if (modFile.getType() == IModFile.Type.LIBRARY) {
                pluginContent.add(modFile);
                continue;
            }
            if (modFile.getType() == IModFile.Type.GAMELIBRARY) {
                gameLibraryContent.add(modFile);
                continue;
            }
            gameContent.add(modFile);
        }
        return ModSorter.sort(pluginContent, gameLibraryContent, gameContent, issues);
    }

    public static LoadingModList sort(List<ModFile> plugins, List<ModFile> gameLibraries, List<ModFile> mods, List<ModLoadingIssue> issues) {
        LoadingModList list;
        ModSorter ms = new ModSorter(mods);
        try {
            ms.buildUniqueList();
        }
        catch (ModLoadingException e) {
            return LoadingModList.of(plugins, gameLibraries, ms.systemMods, ms.systemMods.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).collect(Collectors.toList()), ModSorter.concat(issues, e.getIssues()), Map.of());
        }
        DependencyResolutionResult resolutionResult = ms.verifyDependencyVersions();
        if (!resolutionResult.versionResolution.isEmpty() || !resolutionResult.incompatibilities.isEmpty()) {
            list = LoadingModList.of(plugins, gameLibraries, ms.systemMods, ms.systemMods.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).collect(Collectors.toList()), ModSorter.concat(issues, resolutionResult.buildErrorMessages()), Map.of());
        } else {
            ModLoadingException modLoadingException = null;
            try {
                ms.sort(issues);
            }
            catch (ModLoadingException e) {
                modLoadingException = e;
            }
            list = modLoadingException == null ? LoadingModList.of(plugins, gameLibraries, ms.modFiles, ms.sortedList, issues, ms.modDependencies) : LoadingModList.of(plugins, gameLibraries, ms.modFiles, ms.sortedList, ModSorter.concat(issues, modLoadingException.getIssues()), Map.of());
        }
        if (!resolutionResult.discouraged.isEmpty()) {
            list.getModLoadingIssues().add(ModLoadingIssue.warning("found mod conflicts", resolutionResult.buildWarningMessages()));
        }
        Set loadedMods = Collections.newSetFromMap(new IdentityHashMap());
        list.getModFiles().forEach(mfi -> loadedMods.add(mfi.getFile()));
        for (ModFile modFile : ms.modFiles) {
            if (loadedMods.contains(modFile)) continue;
            modFile.close();
        }
        return list;
    }

    @SafeVarargs
    private static <T> List<T> concat(List<T> ... lists) {
        ArrayList<T> lst = new ArrayList<T>();
        for (List<T> list : lists) {
            lst.addAll(list);
        }
        return lst;
    }

    private void sort(List<ModLoadingIssue> issues) {
        List<ModInfo> sorted;
        MutableGraph graph = GraphBuilder.directed().build();
        AtomicInteger counter = new AtomicInteger();
        Map infos = this.modFiles.stream().flatMap(mf -> mf.getModInfos().stream()).map(ModInfo.class::cast).collect(Collectors.toMap(Function.identity(), e -> counter.incrementAndGet()));
        infos.keySet().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        this.modFiles.stream().map(ModFile::getModInfos).mapMulti(Iterable::forEach).map(IModInfo::getDependencies).mapMulti(Iterable::forEach).forEach(dep -> this.addDependency((MutableGraph<ModInfo>)graph, (IModInfo.ModVersion)dep));
        FMLConfig.getDependencyOverrides().forEach((id, overrides) -> {
            ModInfo target = (ModInfo)this.modIdNameLookup.get(id);
            if (target == null) {
                issues.add(ModLoadingIssue.warning("fml.modloadingissue.depoverride.unknown_target", id));
            } else {
                for (FMLConfig.DependencyOverride override : overrides) {
                    ModInfo dep = (ModInfo)this.modIdNameLookup.get(override.modId());
                    if (dep == null) {
                        issues.add(ModLoadingIssue.warning("fml.modloadingissue.depoverride.unknown_dependency", override.modId(), id));
                        continue;
                    }
                    if (override.remove()) continue;
                    graph.putEdge((Object)dep, (Object)target);
                }
            }
        });
        try {
            sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(infos::get));
        }
        catch (CyclePresentException e2) {
            Set cycles = e2.getCycles();
            if (LOGGER.isErrorEnabled(LogMarkers.LOADING)) {
                LOGGER.error(LogMarkers.LOADING, "Mod Sorting failed.\nDetected Cycles: {}\n", cycles);
            }
            List<ModLoadingIssue> dataList = cycles.stream().mapMulti(Iterable::forEach).mapMulti((mf, c) -> mf.getMods().forEach(c)).map(IModInfo::getModId).map(list -> ModLoadingIssue.error("fml.modloadingissue.cycle", list).withCause(e2)).toList();
            throw new ModLoadingException(dataList);
        }
        this.sortedList = List.copyOf(sorted);
        this.modDependencies = sorted.stream().collect(Collectors.toMap(modInfo -> modInfo, modInfo -> List.copyOf(graph.predecessors(modInfo))));
        this.modFiles = sorted.stream().map(mi -> mi.getOwningFile().getFile()).distinct().toList();
    }

    private void addDependency(MutableGraph<ModInfo> topoGraph, IModInfo.ModVersion dep) {
        ModInfo self = (ModInfo)dep.getOwner();
        IModInfo targetModInfo = this.modIdNameLookup.get(dep.getModId());
        if (!(targetModInfo instanceof ModInfo)) {
            return;
        }
        ModInfo target = (ModInfo)targetModInfo;
        if (self == target) {
            return;
        }
        switch (dep.getOrdering()) {
            case BEFORE: {
                topoGraph.putEdge((Object)self, (Object)target);
                break;
            }
            case AFTER: {
                topoGraph.putEdge((Object)target, (Object)self);
            }
        }
    }

    private void buildUniqueList() {
        UniqueModListBuilder.UniqueModListData uniqueModListData = this.uniqueModListBuilder.buildUniqueList();
        uniqueModListData.discardedFiles().forEach(ModFile::close);
        this.modFiles = uniqueModListData.modFiles();
        this.detectSystemMods(uniqueModListData.modFilesByFirstId());
        this.modIdNameLookup = uniqueModListData.modFiles().stream().flatMap(mf -> mf.getModInfos().stream()).collect(Collectors.toMap(IModInfo::getModId, mi -> mi));
    }

    private void detectSystemMods(Map<String, List<ModFile>> modFilesByFirstId) {
        HashSet<String> systemMods = new HashSet<String>();
        systemMods.add("minecraft");
        systemMods.add("neoforge");
        this.modFiles.stream().map(mf -> mf.getContents().getManifest().getMainAttributes().getValue("FML-System-Mods")).filter(Objects::nonNull).findFirst().ifPresent(value -> systemMods.addAll(Arrays.asList(value.split(","))));
        LOGGER.debug("Configured system mods: {}", systemMods);
        this.systemMods = new ArrayList<ModFile>();
        for (String systemMod : systemMods) {
            List<ModFile> container = modFilesByFirstId.get(systemMod);
            if (container == null || container.isEmpty()) continue;
            LOGGER.debug("Found system mod: {}", (Object)systemMod);
            this.systemMods.add(container.getFirst());
        }
    }

    private DependencyResolutionResult verifyDependencyVersions() {
        Map<String, ArtifactVersion> modVersions = this.modFiles.stream().map(ModFile::getModInfos).mapMulti(Iterable::forEach).collect(Collectors.toMap(IModInfo::getModId, IModInfo::getVersion));
        Map modVersionDependencies = this.modFiles.stream().map(ModFile::getModInfos).mapMulti(Iterable::forEach).collect(Collectors.groupingBy(Function.identity(), Collectors.flatMapping(e -> {
            List<FMLConfig.DependencyOverride> overrides = FMLConfig.getOverrides(e.getModId());
            if (!overrides.isEmpty()) {
                Set ids = overrides.stream().filter(FMLConfig.DependencyOverride::remove).map(FMLConfig.DependencyOverride::modId).collect(Collectors.toSet());
                return e.getDependencies().stream().filter(v -> !ids.contains(v.getModId()));
            }
            return e.getDependencies().stream();
        }, Collectors.toList())));
        Set modRequirements = modVersionDependencies.values().stream().mapMulti(Iterable::forEach).filter(mv -> mv.getSide().isCorrectSide()).collect(Collectors.toSet());
        long mandatoryRequired = modRequirements.stream().filter(ver -> ver.getType() == IModInfo.DependencyType.REQUIRED).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements ({} mandatory, {} optional)", new Object[]{modRequirements.size(), mandatoryRequired, (long)modRequirements.size() - mandatoryRequired});
        Set<IModInfo.ModVersion> missingVersions = modRequirements.stream().filter(mv -> (mv.getType() == IModInfo.DependencyType.REQUIRED || modVersions.containsKey(mv.getModId()) && mv.getType() == IModInfo.DependencyType.OPTIONAL) && this.modVersionNotContained((IModInfo.ModVersion)mv, modVersions)).collect(Collectors.toSet());
        long mandatoryMissing = missingVersions.stream().filter(mv -> mv.getType() == IModInfo.DependencyType.REQUIRED).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements missing ({} mandatory, {} optional)", new Object[]{missingVersions.size(), mandatoryMissing, (long)missingVersions.size() - mandatoryMissing});
        Set<IModInfo.ModVersion> incompatibleVersions = modRequirements.stream().filter(ver -> ver.getType() == IModInfo.DependencyType.INCOMPATIBLE).filter(ver -> modVersions.containsKey(ver.getModId()) && !this.modVersionNotContained((IModInfo.ModVersion)ver, modVersions)).collect(Collectors.toSet());
        Set<IModInfo.ModVersion> discouragedVersions = modRequirements.stream().filter(ver -> ver.getType() == IModInfo.DependencyType.DISCOURAGED).filter(ver -> modVersions.containsKey(ver.getModId()) && !this.modVersionNotContained((IModInfo.ModVersion)ver, modVersions)).collect(Collectors.toSet());
        if (!discouragedVersions.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Conflicts between mods:\n{}\n\tIssues may arise. Continue at your own risk.", (Object)discouragedVersions.stream().map(ver -> ModSorter.formatIncompatibleDependencyError(ver, "discourages", modVersions)).collect(Collectors.joining("\n")));
        }
        if (mandatoryMissing > 0L) {
            LOGGER.error(LogMarkers.LOADING, "Missing or unsupported mandatory dependencies:\n{}", (Object)missingVersions.stream().filter(mv -> mv.getType() == IModInfo.DependencyType.REQUIRED).map(ver -> ModSorter.formatDependencyError(ver, modVersions)).collect(Collectors.joining("\n")));
        }
        if ((long)missingVersions.size() - mandatoryMissing > 0L) {
            LOGGER.error(LogMarkers.LOADING, "Unsupported installed optional dependencies:\n{}", (Object)missingVersions.stream().filter(ver -> ver.getType() == IModInfo.DependencyType.OPTIONAL).map(ver -> ModSorter.formatDependencyError(ver, modVersions)).collect(Collectors.joining("\n")));
        }
        if (!incompatibleVersions.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Incompatibilities between mods:\n{}", (Object)incompatibleVersions.stream().map(ver -> ModSorter.formatIncompatibleDependencyError(ver, "is incompatible with", modVersions)).collect(Collectors.joining("\n")));
        }
        return new DependencyResolutionResult(incompatibleVersions, discouragedVersions, missingVersions, modVersions);
    }

    private static String formatDependencyError(IModInfo.ModVersion dependency, Map<String, ArtifactVersion> modVersions) {
        ArtifactVersion installed = modVersions.get(dependency.getModId());
        return String.format("\tMod ID: '%s', Requested by: '%s', Expected range: '%s', Actual version: '%s'", dependency.getModId(), dependency.getOwner().getModId(), dependency.getVersionRange(), installed != null ? installed.toString() : "[MISSING]");
    }

    private static String formatIncompatibleDependencyError(IModInfo.ModVersion dependency, String type, Map<String, ArtifactVersion> modVersions) {
        return String.format("\tMod '%s' %s '%s', versions: '%s'; Version found: '%s'", dependency.getOwner().getModId(), type, dependency.getModId(), dependency.getVersionRange(), modVersions.get(dependency.getModId()).toString());
    }

    private boolean modVersionNotContained(IModInfo.ModVersion mv, Map<String, ArtifactVersion> modVersions) {
        VersionSupportMatrix versionSupportMatrix = FMLLoader.getCurrent().getVersionSupportMatrix();
        return !versionSupportMatrix.testVersionSupportMatrix(mv.getVersionRange(), mv.getModId(), "mod", (modId, range) -> modVersions.containsKey(modId) && (range.containsVersion((ArtifactVersion)modVersions.get(modId)) || ((ArtifactVersion)modVersions.get(modId)).toString().equals("0.0NONE")));
    }

    public record DependencyResolutionResult(Collection<IModInfo.ModVersion> incompatibilities, Collection<IModInfo.ModVersion> discouraged, Collection<IModInfo.ModVersion> versionResolution, Map<String, ArtifactVersion> modVersions) {
        public List<ModLoadingIssue> buildWarningMessages() {
            return Stream.concat(this.discouraged.stream().map(mv -> ModLoadingIssue.warning("fml.modloadingissue.discouragedmod", mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), this.modVersions.get(mv.getModId()), mv.getReason().orElse("fml.modloadingissue.discouragedmod.noreason")).withAffectedMod(mv.getOwner())), Stream.of(ModLoadingIssue.warning("fml.modloadingissue.discouragedmod.proceed", new Object[0]))).toList();
        }

        public List<ModLoadingIssue> buildErrorMessages() {
            return Stream.concat(this.versionResolution.stream().map(mv -> ModLoadingIssue.error(mv.getType() == IModInfo.DependencyType.REQUIRED ? "fml.modloadingissue.missingdependency" : "fml.modloadingissue.missingdependency.optional", mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), this.modVersions.getOrDefault(mv.getModId(), (ArtifactVersion)new DefaultArtifactVersion("null")), mv.getReason()).withAffectedMod(mv.getOwner())), this.incompatibilities.stream().map(mv -> ModLoadingIssue.error("fml.modloadingissue.incompatiblemod", mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), this.modVersions.get(mv.getModId()), mv.getReason().orElse("fml.modloadingissue.incompatiblemod.noreason")).withAffectedMod(mv.getOwner()))).toList();
        }
    }
}

