/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.ProgramArgs;
import net.neoforged.fml.util.ServiceLoaderUtil;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImmediateWindowHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    static ImmediateWindowProvider provider;

    public static void load(ILaunchContext context, boolean headless, ProgramArgs arguments) {
        ServiceLoaderUtil.loadEarlyServices(context, GraphicsBootstrapper.class, List.of()).forEach(bootstrap -> {
            LOGGER.info("Running graphics bootstrap plugin {}", (Object)bootstrap.name());
            bootstrap.bootstrap(arguments.getArguments());
        });
        if (headless) {
            provider = null;
            LOGGER.info("Not loading early display in headless mode.");
            return;
        }
        if (!FMLConfig.getBoolConfigValue(FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL)) {
            provider = null;
            LOGGER.info("ImmediateWindowProvider not loading because splash screen is disabled");
        } else {
            String providername = FMLConfig.getConfigValue(FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER);
            LOGGER.info("Loading ImmediateWindowProvider {}", (Object)providername);
            Optional<ImmediateWindowProvider> maybeProvider = ServiceLoaderUtil.loadEarlyServices(context, ImmediateWindowProvider.class, List.of()).stream().filter(p -> Objects.equals(p.name(), providername)).findFirst();
            provider = maybeProvider.orElse(null);
            if (provider == null) {
                LOGGER.info("Failed to find ImmediateWindowProvider {}, disabling", (Object)providername);
            } else {
                try {
                    provider.initialize(arguments);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to initialize ImmediateWindowProvider '{}'", (Object)providername, (Object)e);
                    provider = null;
                }
            }
        }
        if (provider != null) {
            FMLConfig.updateConfig(FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER, provider.name());
        }
    }

    public static void setNeoForgeVersion(String version) {
        if (provider != null) {
            provider.setNeoForgeVersion(version);
        }
    }

    public static void setMinecraftVersion(String version) {
        if (provider != null) {
            provider.setMinecraftVersion(version);
        }
    }

    public static void renderTick() {
        if (provider != null) {
            provider.periodicTick();
        }
    }

    public static void updateProgress(String message) {
        if (provider != null) {
            provider.updateProgress(message);
        }
    }

    public static void crash(String message) {
        if (provider != null) {
            provider.crash(message);
        }
    }

    public static void displayFatalErrorAndExit(List<ModLoadingIssue> issues, Path modsFolder, Path logFile, Path crashReportFile) {
        if (provider != null) {
            provider.displayFatalErrorAndExit(issues, modsFolder, logFile, crashReportFile);
        }
    }
}

