/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.instrument.Instrumentation;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.runtime.SwitchBootstraps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.accesstransformer.api.AccessTransformerEngine;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.FMLVersion;
import net.neoforged.fml.IBindingsProvider;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.classloading.JarContentsModule;
import net.neoforged.fml.classloading.JarContentsModuleFinder;
import net.neoforged.fml.classloading.ResourceMaskingClassLoader;
import net.neoforged.fml.classloading.transformation.ClassProcessorAuditLog;
import net.neoforged.fml.classloading.transformation.ClassProcessorAuditSource;
import net.neoforged.fml.classloading.transformation.ClassProcessorSet;
import net.neoforged.fml.classloading.transformation.TransformingClassLoader;
import net.neoforged.fml.common.asm.AccessTransformerService;
import net.neoforged.fml.common.asm.SimpleProcessorsGroup;
import net.neoforged.fml.common.asm.enumextension.RuntimeEnumExtender;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.fml.jarcontents.CompositeJarContents;
import net.neoforged.fml.jarcontents.EmptyJarContents;
import net.neoforged.fml.jarcontents.FolderJarContents;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarFileContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.loading.ClassLoadingGuardian;
import net.neoforged.fml.loading.EarlyServiceDiscovery;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.LanguageProviderLoader;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.ModSorter;
import net.neoforged.fml.loading.ProgramArgs;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.VersionSupportMatrix;
import net.neoforged.fml.loading.mixin.MixinFacade;
import net.neoforged.fml.loading.moddiscovery.ModDiscoverer;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.locators.GameLocator;
import net.neoforged.fml.loading.moddiscovery.locators.InDevFolderLocator;
import net.neoforged.fml.loading.moddiscovery.locators.InDevJarLocator;
import net.neoforged.fml.loading.moddiscovery.locators.ModsFolderLocator;
import net.neoforged.fml.loading.moddiscovery.locators.NeoForgeDevDistCleaner;
import net.neoforged.fml.loading.modscan.BackgroundScanHandler;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.fml.startup.InstrumentationHelper;
import net.neoforged.fml.startup.StartupArgs;
import net.neoforged.fml.util.ClasspathResourceUtils;
import net.neoforged.fml.util.PathPrettyPrinting;
import net.neoforged.fml.util.ServiceLoaderUtil;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ClassProcessorProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public final class FMLLoader
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicReference<@Nullable FMLLoader> current = new AtomicReference();
    @Nullable
    private final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader currentClassLoader;
    private final List<AutoCloseable> ownedResources = new ArrayList<AutoCloseable>();
    private final List<AutoCloseable> closeCallbacks = new ArrayList<AutoCloseable>();
    private final ProgramArgs programArgs;
    private LanguageProviderLoader languageProviderLoader;
    private final Dist dist;
    private LoadingModList loadingModList;
    private final Path gameDir;
    private final Set<Path> locatedPaths = new HashSet<Path>();
    private VersionInfo versionInfo;
    private VersionSupportMatrix versionSupportMatrix;
    public BackgroundScanHandler backgroundScanHandler;
    private final boolean production;
    @Nullable
    private ModuleLayer gameLayer;
    private final List<ModFile> earlyServicesJars = new ArrayList<ModFile>();
    @VisibleForTesting
    DiscoveryResult discoveryResult;
    private final ClassProcessorAuditLog classTransformerAuditLog = new ClassProcessorAuditLog();
    @Nullable
    @VisibleForTesting
    volatile IBindingsProvider bindings;

    @ApiStatus.Internal
    public ClassProcessorAuditSource getClassTransformerAuditLog() {
        return this.classTransformerAuditLog;
    }

    private FMLLoader(ClassLoader currentClassLoader, String[] programArgs, Dist dist, boolean production, Path gameDir) {
        this.currentClassLoader = currentClassLoader;
        this.programArgs = ProgramArgs.from(programArgs);
        this.dist = dist;
        this.production = production;
        this.gameDir = gameDir;
        this.versionInfo = new VersionInfo(this.programArgs.remove("fml.neoForgeVersion"), this.programArgs.remove("fml.mcVersion"), this.programArgs.remove("fml.neoFormVersion"));
        LOGGER.info("Starting FancyModLoader version {} ({} in {})", new Object[]{FMLVersion.getVersion(), dist, production ? "PROD" : "DEV"});
        LOGGER.info("Game directory: {}", (Object)gameDir);
        this.makeCurrent();
    }

    @Nullable
    public IModFile getModFileByClass(Class<?> clazz) {
        String packageName = clazz.getPackageName();
        if (packageName.isEmpty()) {
            return null;
        }
        return this.loadingModList.getPackageIndex().get(packageName);
    }

    public void addCloseCallback(AutoCloseable callback) {
        this.closeCallbacks.add(callback);
    }

    @Override
    public void close() {
        LOGGER.info("Closing FML Loader {}", (Object)Integer.toHexString(System.identityHashCode(this)));
        for (AutoCloseable autoCloseable : this.closeCallbacks) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to run mod-supplied close callback {}", (Object)autoCloseable, (Object)e);
            }
        }
        this.closeCallbacks.clear();
        for (ModFile modFile : this.earlyServicesJars) {
            modFile.close();
        }
        this.earlyServicesJars.clear();
        if (this.loadingModList != null) {
            for (ModFileInfo modFileInfo : this.loadingModList.getModFiles()) {
                modFileInfo.getFile().close();
            }
            for (IModFileInfo iModFileInfo : this.loadingModList.getPlugins()) {
                ((ModFile)iModFileInfo.getFile()).close();
            }
            for (IModFile iModFile : this.loadingModList.getGameLibraries()) {
                ((ModFile)iModFile).close();
            }
        }
        if (this == current.compareAndExchange(this, null)) {
            ModList.clear();
            ModLoader.clear();
        }
        for (AutoCloseable autoCloseable : this.ownedResources) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close resource {} owned by FMLLoader", (Object)autoCloseable, (Object)e);
            }
        }
        this.ownedResources.clear();
        if (Thread.currentThread().getContextClassLoader() == this.currentClassLoader) {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }

    private void makeCurrent() {
        FMLLoader witness = current.compareAndExchange(null, this);
        if (witness != null) {
            throw new IllegalStateException("Another FML loader is already active: " + String.valueOf(witness));
        }
    }

    public ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    public ProgramArgs getProgramArgs() {
        return this.programArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public IBindingsProvider getBindings() {
        if (this.bindings == null) {
            FMLLoader fMLLoader = this;
            synchronized (fMLLoader) {
                if (this.bindings == null) {
                    if (this.gameLayer == null) {
                        throw new IllegalStateException("Cannot retrieve bindings before the game layer is initialized.");
                    }
                    List<ServiceLoader.Provider<IBindingsProvider>> providers = ServiceLoader.load(this.gameLayer, IBindingsProvider.class).stream().toList();
                    if (providers.isEmpty()) {
                        throw new IllegalStateException("Could not find bindings provider");
                    }
                    if (providers.size() > 1) {
                        String providerList = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(", "));
                        throw new IllegalStateException("Found more than one bindings provider: " + providerList);
                    }
                    this.bindings = providers.getFirst().get();
                }
            }
        }
        return this.bindings;
    }

    public static FMLLoader create(StartupArgs startupArgs) {
        Instrumentation instrumentation = InstrumentationHelper.obtainInstrumentation();
        return FMLLoader.create(instrumentation, startupArgs);
    }

    /*
     * WARNING - void declaration
     */
    public static FMLLoader create(@Nullable Instrumentation instrumentation, StartupArgs startupArgs) {
        ClassLoader initialLoader = Objects.requireNonNullElse(startupArgs.parentClassLoader(), ClassLoader.getSystemClassLoader());
        PathPrettyPrinting.addRoot(startupArgs.gameDirectory());
        FMLLoader loader = new FMLLoader(initialLoader, startupArgs.programArgs(), Objects.requireNonNullElseGet(startupArgs.dist(), () -> FMLLoader.detectDist(initialLoader)), FMLLoader.detectProduction(initialLoader), startupArgs.gameDirectory());
        try {
            void var6_12;
            FMLPaths.loadAbsolutePaths(startupArgs.gameDirectory());
            FMLConfig.load();
            LaunchContextAdapter launchContext = loader.new LaunchContextAdapter();
            for (File file : startupArgs.claimedFiles()) {
                launchContext.addLocated(file.toPath());
            }
            loader.loadEarlyServices(startupArgs);
            ImmediateWindowHandler.load(launchContext, startupArgs.headless(), loader.programArgs);
            if (loader.versionInfo.neoForgeVersion() != null) {
                ImmediateWindowHandler.setNeoForgeVersion(loader.versionInfo.neoForgeVersion());
            }
            if (loader.versionInfo.mcVersion() != null) {
                ImmediateWindowHandler.setMinecraftVersion(loader.versionInfo.mcVersion());
            }
            DiscoveryResult discoveryResult = startupArgs.headless() ? loader.runDiscovery() : FMLLoader.runOffThread(loader::runDiscovery);
            for (ModLoadingIssue issue : discoveryResult.discoveryIssues()) {
                LOGGER.atLevel(issue.severity() == ModLoadingIssue.Severity.ERROR ? Level.ERROR : Level.WARN).setCause(issue.cause()).log("{}", (Object)FMLTranslations.translateIssueEnglish(issue));
            }
            ((Stream)discoveryResult.allContent().stream().parallel()).forEach(ModFile::getModuleDescriptor);
            Object var6_10 = null;
            if (instrumentation != null) {
                ClassLoadingGuardian classLoadingGuardian = new ClassLoadingGuardian(instrumentation, discoveryResult.allGameContent());
                loader.ownedResources.add(classLoadingGuardian);
            }
            MixinFacade mixinFacade = new MixinFacade();
            loader.ownedResources.add(mixinFacade);
            loader.loadPlugins(loader.loadingModList.getPlugins());
            loader.languageProviderLoader = new LanguageProviderLoader(launchContext);
            for (ModFile modFile : discoveryResult.gameContent) {
                modFile.identifyLanguage();
            }
            ArrayList<JarContentsModule> gameContent = new ArrayList<JarContentsModule>();
            for (ModFile modFile : discoveryResult.allGameContent()) {
                gameContent.add(new JarContentsModule(modFile.getContents(), modFile.getModuleDescriptor()));
            }
            ClassProcessorSet classProcessorSet = FMLLoader.createClassProcessorSet(startupArgs, launchContext, discoveryResult, mixinFacade);
            if (!classProcessorSet.getGeneratedPackages().isEmpty()) {
                ModuleDescriptor descriptor = ModuleDescriptor.newAutomaticModule("net.neoforged.fml.generated").packages(classProcessorSet.getGeneratedPackages()).build();
                gameContent.add(new JarContentsModule(JarContents.empty(Path.of("VirtualJar/" + descriptor.name(), new String[0])), descriptor));
            }
            TransformingClassLoader transformingLoader = loader.buildTransformingLoader(classProcessorSet, loader.classTransformerAuditLog, gameContent);
            if (var6_12 != null) {
                var6_12.setAllowedClassLoader(transformingLoader);
            }
            mixinFacade.finishInitialization(loader.loadingModList, transformingLoader);
            ImmediateWindowHandler.updateProgress("Launching minecraft");
            ImmediateWindowHandler.renderTick();
            return loader;
        }
        catch (Error | RuntimeException e) {
            try {
                loader.close();
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
            throw e;
        }
    }

    private static ClassProcessorSet createClassProcessorSet(StartupArgs startupArgs, LaunchContextAdapter launchContext, DiscoveryResult discoveryResult, MixinFacade mixinFacade) {
        JarContents minecraftModFile;
        ArrayList<ClassProcessor> builtInProcessors = new ArrayList<ClassProcessor>();
        builtInProcessors.add(FMLLoader.createAccessTransformerService(discoveryResult));
        builtInProcessors.add(new RuntimeEnumExtender());
        builtInProcessors.add(new SimpleProcessorsGroup());
        if (startupArgs.cleanDist() && (minecraftModFile = (JarContents)discoveryResult.gameContent().stream().filter(mf -> mf.getId().equals("minecraft")).findFirst().map(ModFile::getContents).orElse(null)) != null && NeoForgeDevDistCleaner.supportsDistCleaning(minecraftModFile)) {
            builtInProcessors.add(new NeoForgeDevDistCleaner(minecraftModFile, startupArgs.dist()));
        }
        builtInProcessors.add(mixinFacade.getClassProcessor());
        return ClassProcessorSet.builder().markMarker(ClassProcessorIds.SIMPLE_PROCESSORS_GROUP).markMarker(ClassProcessorIds.COMPUTING_FRAMES).addProcessors(ServiceLoaderUtil.loadServices((ILaunchContext)launchContext, ClassProcessor.class, builtInProcessors)).addProcessorProviders(ServiceLoaderUtil.loadServices(launchContext, ClassProcessorProvider.class)).build();
    }

    private static ClassProcessor createAccessTransformerService(DiscoveryResult discoveryResult) {
        AccessTransformerEngine engine = AccessTransformerEngine.newEngine();
        for (ModFile modFile : discoveryResult.gameContent()) {
            for (String atPath : modFile.getAccessTransformers()) {
                LOGGER.debug(LogMarkers.SCAN, "Adding Access Transformer {} in {}", (Object)atPath, (Object)modFile);
                try {
                    InputStream in = modFile.getContents().openFile(atPath);
                    try {
                        if (in == null) {
                            LOGGER.error(LogMarkers.LOADING, "Access transformer file {} provided by {} does not exist!", (Object)atPath, (Object)modFile);
                            continue;
                        }
                        engine.loadAT((Reader)new InputStreamReader(new BufferedInputStream(in)), atPath);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load AT at " + atPath + " from " + String.valueOf(modFile), e);
                }
            }
        }
        return new AccessTransformerService(engine);
    }

    private TransformingClassLoader buildTransformingLoader(ClassProcessorSet classProcessorSet, ClassProcessorAuditLog auditTrail, List<JarContentsModule> content) {
        this.maskContentAlreadyOnClasspath(content);
        long start = System.currentTimeMillis();
        List<ModuleLayer> parentLayers = List.of(ModuleLayer.boot());
        Configuration cf = Configuration.resolveAndBind(new JarContentsModuleFinder(content), parentLayers.stream().map(ModuleLayer::configuration).toList(), ModuleFinder.of(new Path[0]), content.stream().map(JarContentsModule::moduleName).toList());
        String moduleNames = FMLLoader.getModuleNameList(cf, content);
        LOGGER.info("Building game content classloader:\n{}", (Object)moduleNames);
        TransformingClassLoader loader = new TransformingClassLoader(classProcessorSet, auditTrail, cf, parentLayers, this.currentClassLoader);
        ModuleLayer layer = ModuleLayer.defineModules(cf, parentLayers, f -> loader).layer();
        long elapsed = System.currentTimeMillis() - start;
        LOGGER.info("Built game content classloader in {}ms", (Object)elapsed);
        loader.setFallbackClassLoader(this.currentClassLoader);
        this.gameLayer = layer;
        this.ownedResources.add(loader);
        this.currentClassLoader = loader;
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    private void maskContentAlreadyOnClasspath(List<JarContentsModule> content) {
        Set<Path> classpathItems = ClasspathResourceUtils.getAllClasspathItems(this.currentClassLoader);
        HashSet<Path> needsMasking = new HashSet<Path>();
        for (JarContentsModule secureJar : content) {
            for (Path basePath : FMLLoader.getBasePaths(secureJar.contents(), true)) {
                if (!classpathItems.contains(basePath)) continue;
                needsMasking.add(basePath);
            }
        }
        if (!needsMasking.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Masking classpath elements: {}", needsMasking.stream().map(PathPrettyPrinting::prettyPrint).toList());
            }
            ResourceMaskingClassLoader maskedLoader = new ResourceMaskingClassLoader(this.currentClassLoader, needsMasking);
            if (Thread.currentThread().getContextClassLoader() == this.currentClassLoader) {
                Thread.currentThread().setContextClassLoader(maskedLoader);
            }
            this.currentClassLoader = maskedLoader;
        }
    }

    private static List<Path> getBasePaths(JarContents contents, boolean ignoreFilter) {
        ArrayList<Path> result = new ArrayList<Path>();
        JarContents jarContents = contents;
        Objects.requireNonNull(jarContents);
        JarContents jarContents2 = jarContents;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompositeJarContents.class, EmptyJarContents.class, FolderJarContents.class, JarFileContents.class}, (Object)jarContents2, n)) {
            case 0: {
                CompositeJarContents compositeModContainer = (CompositeJarContents)jarContents2;
                if (!ignoreFilter && compositeModContainer.isFiltered()) {
                    throw new IllegalStateException("Cannot load filtered Jar content into a URL classloader");
                }
                for (JarContents delegate : compositeModContainer.getDelegates()) {
                    result.addAll(FMLLoader.getBasePaths(delegate, ignoreFilter));
                }
                break;
            }
            case 1: {
                EmptyJarContents ignored = (EmptyJarContents)jarContents2;
                break;
            }
            case 2: {
                FolderJarContents folderModContainer = (FolderJarContents)jarContents2;
                result.add(folderModContainer.getPrimaryPath());
                break;
            }
            case 3: {
                JarFileContents jarModContainer = (JarFileContents)jarContents2;
                result.add(jarModContainer.getPrimaryPath());
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to handle " + String.valueOf(contents));
            }
        }
        return result;
    }

    private static String getModuleNameList(Configuration cf, List<JarContentsModule> content) {
        Map jarsById = content.stream().collect(Collectors.toMap(JarContentsModule::moduleName, Function.identity()));
        return cf.modules().stream().map(module -> {
            JarContentsModule jar = (JarContentsModule)jarsById.get(module.name());
            JarContents contentList = jar != null ? jar.contents() : module.reference().location().map(URI::toString).orElse("unknown");
            return " - " + module.name() + " (" + String.valueOf(contentList) + ")";
        }).sorted().collect(Collectors.joining("\n"));
    }

    private static Dist detectDist(ClassLoader classLoader) {
        boolean clientAvailable = classLoader.getResource("net/minecraft/client/main/Main.class") != null;
        return clientAvailable ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    private static boolean detectProduction(ClassLoader classLoader) {
        return classLoader.getResource("net/minecraft/DetectedVersion.class") == null;
    }

    private void loadEarlyServices(StartupArgs startupArgs) {
        this.earlyServicesJars.addAll(EarlyServiceDiscovery.findEarlyServiceJars(startupArgs, FMLPaths.MODSDIR.get()));
        if (!this.earlyServicesJars.isEmpty()) {
            this.appendLoader("FML Early Services", this.earlyServicesJars.stream().map(IModFile::getContents).toList());
        }
    }

    private void loadPlugins(List<IModFileInfo> plugins) {
        this.appendLoader("FML Plugins", plugins.stream().map(mfi -> mfi.getFile().getContents()).toList());
    }

    private void appendLoader(String loaderName, List<JarContents> jars) {
        if (jars.isEmpty()) {
            LOGGER.info("No additional classpath items for {} were found.", (Object)loaderName);
            return;
        }
        LOGGER.info("Loading {}:", (Object)loaderName);
        ArrayList<URL> rootUrls = new ArrayList<URL>(jars.size());
        for (JarContents jar : jars) {
            CompositeJarContents compositeJarContents;
            if (jar instanceof CompositeJarContents && (compositeJarContents = (CompositeJarContents)jar).isFiltered()) {
                throw new IllegalArgumentException("Cannot use simple URLClassLoader for filtered content " + String.valueOf(jar));
            }
            for (Path contentRoot : jar.getContentRoots()) {
                LOGGER.info(" - {}", (Object)PathPrettyPrinting.prettyPrint(contentRoot));
                try {
                    rootUrls.add(contentRoot.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.locatedPaths.add(contentRoot);
            }
        }
        URLClassLoader loader = new URLClassLoader(loaderName, (URL[])rootUrls.toArray(URL[]::new), this.currentClassLoader);
        this.ownedResources.add(loader);
        this.currentClassLoader = loader;
        Thread.currentThread().setContextClassLoader(loader);
    }

    private DiscoveryResult runDiscovery() {
        ProgressMeter progress = StartupNotificationManager.prependProgressBar("Discovering mods...", 0);
        ArrayList<IModFileCandidateLocator> additionalLocators = new ArrayList<IModFileCandidateLocator>();
        additionalLocators.add(new GameLocator());
        additionalLocators.add(new InDevFolderLocator());
        additionalLocators.add(new InDevJarLocator());
        additionalLocators.add(new ModsFolderLocator());
        ModDiscoverer modDiscoverer = new ModDiscoverer(new LaunchContextAdapter(), additionalLocators);
        ModDiscoverer.Result discoveryResult = modDiscoverer.discoverMods(this.earlyServicesJars);
        ArrayList<ModFile> modFiles = new ArrayList<ModFile>(discoveryResult.modFiles());
        ArrayList<ModLoadingIssue> issues = new ArrayList<ModLoadingIssue>(discoveryResult.discoveryIssues());
        String neoForgeVersion = this.versionInfo.neoForgeVersion();
        String minecraftVersion = this.versionInfo.mcVersion();
        for (ModFile modFile : discoveryResult.modFiles()) {
            List<IModInfo> mods = modFile.getModFileInfo().getMods();
            if (mods.isEmpty()) continue;
            IModInfo mainMod = mods.getFirst();
            switch (modFile.getId()) {
                case "minecraft": {
                    minecraftVersion = mainMod.getVersion().toString();
                    break;
                }
                case "neoforge": {
                    neoForgeVersion = mainMod.getVersion().toString();
                }
            }
        }
        this.versionInfo = new VersionInfo(neoForgeVersion, minecraftVersion, this.getVersionInfo().neoFormVersion());
        this.versionSupportMatrix = new VersionSupportMatrix(this.versionInfo);
        progress.complete();
        ImmediateWindowHandler.setMinecraftVersion(this.versionInfo.mcVersion());
        ImmediateWindowHandler.setNeoForgeVersion(this.versionInfo.neoForgeVersion());
        this.loadingModList = ModSorter.sort(discoveryResult.modFiles(), issues);
        this.backgroundScanHandler = new BackgroundScanHandler();
        this.backgroundScanHandler.setLoadingModList(this.loadingModList);
        HashMap<IModInfo, JarResource> enumExtensionsByMod = new HashMap<IModInfo, JarResource>();
        for (ModFile modFile : modFiles) {
            List<IModInfo> mods = modFile.getModInfos();
            for (IModInfo mod : mods) {
                mod.getConfig().getConfigElement("enumExtensions").ifPresent(file -> {
                    JarResource resource = mod.getOwningFile().getFile().getContents().get((String)file);
                    if (resource == null) {
                        ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.enumextender.file_not_found", file).withAffectedMod(mod));
                        return;
                    }
                    enumExtensionsByMod.put(mod, resource);
                });
            }
            this.backgroundScanHandler.submitForScanning(modFile);
        }
        RuntimeEnumExtender.loadEnumPrototypes(enumExtensionsByMod);
        this.discoveryResult = new DiscoveryResult(this.loadingModList.getPlugins().stream().map(mfi -> (ModFile)mfi.getFile()).toList(), this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).toList(), this.loadingModList.getGameLibraries().stream().map(mf -> (ModFile)mf).toList(), issues);
        return this.discoveryResult;
    }

    private static <T> T runOffThread(Supplier<T> supplier) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
            ClassLoader previousCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                Object t = supplier.get();
                return t;
            }
            catch (Throwable e) {
                LOGGER.error("Off-thread operation failed.", e);
                throw new CompletionException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousCl);
            }
        });
        while (true) {
            ImmediateWindowHandler.renderTick();
            try {
                return (T)future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for future", e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static LanguageProviderLoader getLanguageLoadingProvider() {
        return FMLLoader.getCurrent().languageProviderLoader;
    }

    public static FMLLoader getCurrent() {
        FMLLoader current = FMLLoader.getCurrentOrNull();
        if (current == null) {
            throw new IllegalStateException("There is no current FML Loader");
        }
        return current;
    }

    @Nullable
    public static FMLLoader getCurrentOrNull() {
        return current.get();
    }

    public Dist getDist() {
        return this.dist;
    }

    public LoadingModList getLoadingModList() {
        if (this.loadingModList == null) {
            throw new IllegalStateException("The loading mod list isn't built yet.");
        }
        return this.loadingModList;
    }

    public Path getGameDir() {
        return this.gameDir;
    }

    public boolean isProduction() {
        return this.production;
    }

    public ModuleLayer getGameLayer() {
        if (this.gameLayer == null) {
            throw new IllegalStateException("This can only be called after mod discovery is completed");
        }
        return this.gameLayer;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    VersionSupportMatrix getVersionSupportMatrix() {
        if (this.versionSupportMatrix == null) {
            throw new IllegalStateException("Mod discovery has not completed yet, versions may not be known.");
        }
        return this.versionSupportMatrix;
    }

    private class LaunchContextAdapter
    implements ILaunchContext {
        private LaunchContextAdapter() {
        }

        @Override
        public Dist getRequiredDistribution() {
            return FMLLoader.this.dist;
        }

        @Override
        public Path gameDirectory() {
            return FMLLoader.this.gameDir;
        }

        @Override
        public <T> Stream<ServiceLoader.Provider<T>> loadServices(Class<T> serviceClass) {
            return ServiceLoader.load(serviceClass).stream();
        }

        @Override
        public boolean isLocated(Path path) {
            return FMLLoader.this.locatedPaths.contains(path);
        }

        @Override
        public boolean addLocated(Path path) {
            return FMLLoader.this.locatedPaths.add(path);
        }

        @Override
        public VersionInfo getVersions() {
            return FMLLoader.this.versionInfo;
        }
    }

    @VisibleForTesting
    record DiscoveryResult(List<ModFile> pluginContent, List<ModFile> gameContent, List<ModFile> gameLibraryContent, List<ModLoadingIssue> discoveryIssues) {
        public List<ModFile> allContent() {
            ArrayList<ModFile> content = new ArrayList<ModFile>(this.pluginContent.size() + this.gameContent.size() + this.gameLibraryContent.size());
            content.addAll(this.pluginContent);
            content.addAll(this.gameContent);
            content.addAll(this.gameLibraryContent);
            return content;
        }

        public List<ModFile> allGameContent() {
            ArrayList<ModFile> content = new ArrayList<ModFile>(this.gameContent.size() + this.gameLibraryContent.size());
            content.addAll(this.gameContent);
            content.addAll(this.gameLibraryContent);
            return content;
        }
    }
}

