/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarmoduleinfo.JarModuleInfo;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.fml.startup.FatalStartupException;
import net.neoforged.fml.startup.StartupArgs;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IModFileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class EarlyServiceDiscovery {
    private static final Logger LOGGER = LogManager.getLogger(EarlyServiceDiscovery.class);
    private static final Set<Class<?>> SERVICES = Set.of(IModFileCandidateLocator.class, IModFileReader.class, IDependencyLocator.class, GraphicsBootstrapper.class, ImmediateWindowProvider.class);

    private EarlyServiceDiscovery() {
    }

    public static List<ModFile> findEarlyServiceJars(StartupArgs startupArgs, Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return List.of();
        }
        long start = System.currentTimeMillis();
        final HashSet<Path> candidates = new HashSet<Path>();
        try {
            Files.walkFileTree(directory, Set.of(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().endsWith(".jar") && attrs.isRegularFile() && attrs.size() > 0L) {
                        candidates.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new FatalStartupException("Failed to find early startup services: " + String.valueOf(e));
        }
        EarlyServiceDiscovery.findClasspathServices(startupArgs, candidates);
        List<ModFile> earlyServiceJars = candidates.parallelStream().map(EarlyServiceDiscovery::getEarlyServiceModFile).filter(Objects::nonNull).toList();
        LOGGER.info("Found {} early service jars (out of {}) in {}ms", (Object)earlyServiceJars.size(), (Object)candidates.size(), (Object)(System.currentTimeMillis() - start));
        return earlyServiceJars;
    }

    private static void findClasspathServices(StartupArgs startupArgs, Set<Path> candidates) {
        for (File file : startupArgs.unclaimedClassPathEntries()) {
            if (!file.isFile()) continue;
            candidates.add(file.toPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ModFile getEarlyServiceModFile(Path path) {
        try (JarFile jarFile = new JarFile(path.toFile(), false, 1);){
            Class<?> service;
            String serviceClass;
            Iterator<Class<?>> iterator = SERVICES.iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while (jarFile.getEntry("META-INF/services/" + (serviceClass = (service = iterator.next()).getName())) == null);
            LOGGER.debug("{} contains early service {}", (Object)path, (Object)serviceClass);
            ModFile modFile = EarlyServiceDiscovery.createEarlyServiceModFile(path);
            return modFile;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read Jar file {} in mods directory: {}", (Object)path, (Object)e);
        }
        return null;
    }

    private static ModFile createEarlyServiceModFile(Path path) throws IOException {
        JarContents contents = JarContents.ofPath(path);
        try {
            return (ModFile)IModFile.create(contents, JarModuleInfo.from(contents), JarModsDotTomlModFileReader::manifestParser);
        }
        catch (Exception e) {
            try {
                contents.close();
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }
}

