/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarmoduleinfo;

import java.util.Set;

final class JlsConstants {
    static final Set<String> RESERVED_KEYWORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "_");

    public static boolean isJavaIdentifier(String str) {
        int codePoint;
        if (str.isEmpty() || RESERVED_KEYWORDS.contains(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(str, i);
            if ((i != 0 || Character.isJavaIdentifierStart(codePoint)) && Character.isJavaIdentifierPart(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static String getPackageName(String typeName) {
        int lastSeparator = typeName.lastIndexOf(46);
        if (lastSeparator != -1) {
            return typeName.substring(0, lastSeparator);
        }
        return "";
    }

    public static boolean isTypeName(String name) {
        int nextSep = -1;
        int lastSep = 0;
        nextSep = name.indexOf(46);
        while (nextSep != -1) {
            String segment = name.substring(lastSep, nextSep);
            lastSep = nextSep + 1;
            if (!JlsConstants.isJavaIdentifier(segment)) {
                return false;
            }
            nextSep = name.indexOf(46, lastSep);
        }
        String lastSegment = name.substring(lastSep);
        return JlsConstants.isJavaIdentifier(lastSegment);
    }

    private JlsConstants() {
    }
}

