/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading.transformation;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.Supplier;
import net.neoforged.fml.classloading.transformation.ClassHierarchyRecomputationContext;
import net.neoforged.fml.classloading.transformation.ClassProcessorAuditLog;
import net.neoforged.fml.classloading.transformation.ClassProcessorSet;
import net.neoforged.fml.classloading.transformation.ClassTransformStatistics;
import net.neoforged.fml.classloading.transformation.TransformerClassWriter;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

@ApiStatus.Internal
public class ClassTransformer {
    private static final byte[] EMPTY = ClassTransformer.getSha256().digest(new byte[0]);
    private static final Logger LOGGER = LogManager.getLogger();
    private final Marker CLASSDUMP = MarkerManager.getMarker((String)"CLASSDUMP");
    private final ClassProcessorSet processors;
    private final ClassProcessorAuditLog auditTrail;
    private static volatile Path tempDir;

    public ClassTransformer(ClassProcessorSet processors, ClassProcessorAuditLog auditTrail) {
        this.processors = processors;
        this.auditTrail = auditTrail;
    }

    public byte[] transform(byte[] inputClass, String className, ProcessorName upToTransformer, ClassHierarchyRecomputationContext locator) {
        Supplier<byte[]> digest;
        boolean isEmpty;
        String internalName = className.replace('.', '/');
        Type classDesc = Type.getObjectType((String)internalName);
        ClassTransformStatistics.incrementLoadedClasses();
        List<ClassProcessor> transformersToUse = this.processors.transformersFor(classDesc, inputClass.length == 0, upToTransformer);
        if (transformersToUse.isEmpty()) {
            return inputClass;
        }
        ClassTransformStatistics.incrementTransformedClasses();
        ClassNode clazz = new ClassNode(589824);
        boolean bl = isEmpty = inputClass.length == 0;
        if (inputClass.length > 0) {
            ClassReader classReader = new ClassReader(inputClass);
            classReader.accept((ClassVisitor)clazz, 8);
            digest = () -> ClassTransformer.getSha256().digest(inputClass);
        } else {
            clazz.name = classDesc.getInternalName();
            clazz.version = 52;
            clazz.superName = Type.getInternalName(Object.class);
            digest = () -> EMPTY;
        }
        boolean allowsComputeFrames = false;
        ClassProcessor.ComputeFlags flags = ClassProcessor.ComputeFlags.NO_REWRITE;
        for (ClassProcessor transformer : transformersToUse) {
            if (ClassProcessorIds.COMPUTING_FRAMES.equals(transformer.name())) {
                allowsComputeFrames = true;
                continue;
            }
            ClassProcessorAuditLog.TransformerActivity trail = this.auditTrail.forClassProcessor(classDesc.getClassName(), transformer);
            ClassProcessor.TransformationContext context = new ClassProcessor.TransformationContext(classDesc, clazz, isEmpty, trail, digest);
            ClassProcessor.ComputeFlags newFlags = transformer.processClass(context);
            if (newFlags != ClassProcessor.ComputeFlags.NO_REWRITE) {
                trail.rewrites();
                isEmpty = false;
            }
            if ((flags = flags.max(newFlags)).ordinal() < ClassProcessor.ComputeFlags.COMPUTE_FRAMES.ordinal()) continue;
            if (!this.processors.canRecomputeFrames(transformer.name())) {
                LOGGER.error("Transformer {} requested COMPUTE_FRAMES but does not depend, directly or indirectly, on running after {}", (Object)transformer.name(), (Object)ClassProcessorIds.COMPUTING_FRAMES);
                throw new IllegalStateException("Transformer " + String.valueOf(transformer.name()) + " requested COMPUTE_FRAMES but does not depend, directly or indirectly, on running after " + String.valueOf(ClassProcessorIds.COMPUTING_FRAMES));
            }
            if (allowsComputeFrames) continue;
            LOGGER.error("Transformer {} requested COMPUTE_FRAMES but is not allowed to do so as it runs before transformer {}", (Object)transformer.name(), (Object)ClassProcessorIds.COMPUTING_FRAMES);
            throw new IllegalStateException("Transformer " + String.valueOf(transformer.name()) + " requested COMPUTE_FRAMES but is not allowed to do so as it runs before transformer " + String.valueOf(ClassProcessorIds.COMPUTING_FRAMES));
        }
        if (upToTransformer == null) {
            ClassProcessor.AfterProcessingContext context = new ClassProcessor.AfterProcessingContext(classDesc);
            for (ClassProcessor transformer : transformersToUse) {
                transformer.afterProcessing(context);
            }
        }
        if (flags == ClassProcessor.ComputeFlags.NO_REWRITE) {
            return inputClass;
        }
        ClassWriter cw = ClassTransformer.createClassWriter(flags, clazz, locator);
        clazz.accept((ClassVisitor)cw);
        if (LOGGER.isEnabled(Level.TRACE) && upToTransformer == null && LOGGER.isEnabled(Level.TRACE, this.CLASSDUMP)) {
            this.dumpClass(cw.toByteArray(), className);
        }
        return cw.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void dumpClass(byte[] clazz, String className) {
        if (tempDir == null) {
            Class<ClassTransformer> clazz2 = ClassTransformer.class;
            // MONITORENTER : net.neoforged.fml.classloading.transformation.ClassTransformer.class
            if (tempDir == null) {
                try {
                    tempDir = Files.createTempDirectory("classDump", new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to create temporary directory");
                    // MONITOREXIT : clazz2
                    return;
                }
            }
            // MONITOREXIT : clazz2
        }
        try {
            Path tempFile = tempDir.resolve(className + ".class");
            Files.write(tempFile, clazz, new OpenOption[0]);
            LOGGER.info("Wrote {} byte class file {} to {}", (Object)clazz.length, (Object)className, (Object)tempFile);
            return;
        }
        catch (IOException e) {
            LOGGER.error("Failed to write class file {}", (Object)className, (Object)e);
        }
    }

    private static MessageDigest getSha256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HUH");
        }
    }

    private static ClassWriter createClassWriter(ClassProcessor.ComputeFlags flags, ClassNode clazzAccessor, ClassHierarchyRecomputationContext locator) {
        int writerFlag = switch (flags) {
            case ClassProcessor.ComputeFlags.COMPUTE_MAXS -> 1;
            case ClassProcessor.ComputeFlags.COMPUTE_FRAMES -> 2;
            default -> 0;
        };
        return flags.ordinal() >= ClassProcessor.ComputeFlags.COMPUTE_FRAMES.ordinal() ? new TransformerClassWriter(writerFlag, clazzAccessor, locator) : new ClassWriter(writerFlag);
    }
}

