/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.classloading.transformation.TransformingClassLoader;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.mixin.FMLMixinClassProcessor;
import net.neoforged.fml.loading.mixin.FMLMixinService;
import net.neoforged.fml.loading.mixin.FMLMixinServiceBootstrap;
import net.neoforged.fml.loading.mixin.FMLModFileContainerHandle;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.FabricUtil;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.service.MixinService;

public final class MixinFacade
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MixinFacade.class);
    private final FMLMixinClassProcessor classProcessor;
    private final FMLMixinService service;
    @VisibleForTesting
    public static final int DEFAULT_BEHAVIOUR_VERSION = 14000;
    @VisibleForTesting
    public static final ArtifactVersion HIGHEST_MIXIN_VERSION = new DefaultArtifactVersion(Optional.ofNullable(FabricUtil.class.getModule().getDescriptor()).flatMap(ModuleDescriptor::version).map(ModuleDescriptor.Version::toString).or(() -> Optional.ofNullable(FabricUtil.class.getPackage().getImplementationVersion())).orElseThrow(() -> new IllegalStateException("Cannot determine version of currently running mixin")));
    @VisibleForTesting
    public static final ArtifactVersion LOWEST_MIXIN_VERSION;

    public MixinFacade() {
        if (FMLLoader.getCurrent().getDist() == null) {
            throw new IllegalStateException("The dist must be set before initializing Mixin");
        }
        System.setProperty("mixin.service", FMLMixinService.class.getName());
        System.setProperty("mixin.bootstrapService", FMLMixinServiceBootstrap.class.getName());
        MixinBootstrap.init();
        this.service = (FMLMixinService)MixinService.getService();
        this.classProcessor = new FMLMixinClassProcessor(this.service);
    }

    public FMLMixinClassProcessor getClassProcessor() {
        return this.classProcessor;
    }

    public void finishInitialization(LoadingModList loadingModList, TransformingClassLoader classLoader) {
        if (Thread.currentThread().getContextClassLoader() != classLoader) {
            throw new IllegalStateException("The class loader must be the context classloader in order to find the Mixin configurations.");
        }
        this.addMixins(loadingModList);
        this.gotoPhase(MixinEnvironment.Phase.INIT);
        this.gotoPhase(MixinEnvironment.Phase.DEFAULT);
        MixinBootstrap.init();
        MixinBootstrap.getPlatform().inject();
    }

    private void gotoPhase(MixinEnvironment.Phase phase) {
        try {
            Method m = MixinEnvironment.class.getDeclaredMethod("gotoPhase", MixinEnvironment.Phase.class);
            m.setAccessible(true);
            m.invoke(null, phase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addMixins(LoadingModList modList) {
        record AnnotationInfo(IModFile modFile, int behaviorVersion) {
        }
        HashMap<String, AnnotationInfo> configAnnotationInfo = new HashMap<String, AnnotationInfo>();
        for (ModFileInfo modFileInfo : modList.getModFiles()) {
            ModFile modFile = modFileInfo.getFile();
            for (ModFileParser.MixinConfig mixinConfig : modFile.getMixinConfigs()) {
                byte[] configContent;
                if (!MixinFacade.areRequiredModsPresent(modFile, mixinConfig, modList) || !MixinFacade.validateMixinBehavior(modFile, mixinConfig)) continue;
                AnnotationInfo currentInfo = new AnnotationInfo(modFile, MixinFacade.calculateBehaviorVersion(mixinConfig.behaviorVersion()));
                AnnotationInfo existingInfo = configAnnotationInfo.putIfAbsent(mixinConfig.config(), currentInfo);
                if (existingInfo != null && existingInfo.modFile() != modFile) {
                    ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.mixin.duplicate_config", mixinConfig.config(), existingInfo.modFile).withAffectedModFile(modFile));
                    continue;
                }
                try {
                    configContent = modFile.getContents().readFile(mixinConfig.config());
                }
                catch (IOException ignored) {
                    configContent = null;
                }
                if (configContent == null) {
                    for (IModFile otherModFile : modList.getAllModFiles()) {
                        if (otherModFile == modFile) continue;
                        try {
                            configContent = otherModFile.getContents().readFile(mixinConfig.config());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (configContent == null) continue;
                        LOG.warn("Mod file {} declares mixin config {}, but it actually comes from {}", new Object[]{modFile, mixinConfig.config(), otherModFile});
                        break;
                    }
                }
                if (configContent == null) {
                    ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.mixin.missing_config", mixinConfig.config()).withAffectedModFile(modFile));
                    continue;
                }
                this.service.addMixinConfigContent(mixinConfig.config(), configContent);
                Mixins.addConfiguration((String)mixinConfig.config());
            }
        }
        for (IModFileInfo plugin : modList.getPlugins()) {
            this.service.addMixinContainer(new FMLModFileContainerHandle(plugin.getFile()));
        }
        for (IModFile gameLibrary : modList.getGameLibraries()) {
            this.service.addMixinContainer(new FMLModFileContainerHandle(gameLibrary));
        }
        Map<String, IMixinConfig> configMap = Mixins.getConfigs().stream().collect(Collectors.toMap(Config::getName, Config::getConfig));
        for (Map.Entry entry : configAnnotationInfo.entrySet()) {
            String mixinConfigName = (String)entry.getKey();
            AnnotationInfo annotationInfo = (AnnotationInfo)entry.getValue();
            IMixinConfig config = configMap.get(mixinConfigName);
            if (config == null) {
                LOG.error("Mixin config {} from {} was not registered!", (Object)mixinConfigName, (Object)annotationInfo.modFile());
                continue;
            }
            config.decorate("fabric-modId", (Object)annotationInfo.modFile().getId());
            config.decorate("fabric-compat", (Object)annotationInfo.behaviorVersion());
        }
    }

    private static boolean areRequiredModsPresent(ModFile modFile, ModFileParser.MixinConfig mixinConfig, LoadingModList modList) {
        for (String requiredModId : mixinConfig.requiredMods()) {
            if (modList.getModFileById(requiredModId) != null) continue;
            LOG.info("Mixin config {} from {} not applied as required mod '{}' is missing", new Object[]{mixinConfig.config(), modFile, requiredModId});
            return false;
        }
        return true;
    }

    private static boolean validateMixinBehavior(ModFile modFile, ModFileParser.MixinConfig mixinConfig) {
        ArtifactVersion behaviorVersion = mixinConfig.behaviorVersion();
        if (behaviorVersion == null) {
            return true;
        }
        if (behaviorVersion.compareTo((Object)HIGHEST_MIXIN_VERSION) > 0) {
            ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.mixin.requested_behavior_too_new", mixinConfig.config(), behaviorVersion, HIGHEST_MIXIN_VERSION).withAffectedModFile(modFile));
            return false;
        }
        if (behaviorVersion.compareTo((Object)LOWEST_MIXIN_VERSION) < 0) {
            ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.mixin.requested_behavior_too_old", mixinConfig.config(), behaviorVersion, LOWEST_MIXIN_VERSION).withAffectedModFile(modFile));
            return false;
        }
        return true;
    }

    private static int calculateBehaviorVersion(@Nullable ArtifactVersion behaviorVersion) {
        if (behaviorVersion == null) {
            return 14000;
        }
        return behaviorVersion.getMajorVersion() * 1000000 + behaviorVersion.getMinorVersion() * 1000 + behaviorVersion.getIncrementalVersion();
    }

    @Override
    public void close() {
        this.service.setBytecodeProvider(null);
    }

    static {
        int defaultMixinVersion = 14000;
        int patch = defaultMixinVersion % 1000;
        int minor = (defaultMixinVersion /= 1000) % 1000;
        int major = defaultMixinVersion /= 1000;
        LOWEST_MIXIN_VERSION = new DefaultArtifactVersion(major + "." + minor + "." + patch);
    }
}

