/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.progress;

public class Message {
    private final String text;
    private final MessageType type;
    private final long timestamp;

    public Message(String text, MessageType type) {
        this.text = text;
        this.type = type;
        this.timestamp = System.nanoTime();
    }

    public String getText() {
        return this.text;
    }

    MessageType getType() {
        return this.type;
    }

    long timestamp() {
        return this.timestamp;
    }

    public float[] getTypeColour() {
        return this.type.colour();
    }

    public static enum MessageType {
        MC(1.0f, 1.0f, 1.0f),
        ML(0.0f, 0.0f, 0.5f),
        LOC(0.0f, 0.5f, 0.0f),
        MOD(0.5f, 0.0f, 0.0f);

        private final float[] colour;

        private MessageType(float r, float g, float b) {
            this.colour = new float[]{r, g, b};
        }

        public float[] colour() {
            return this.colour;
        }
    }
}

