/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import java.util.function.BiConsumer;
import org.spongepowered.asm.service.IMixinAuditTrail;

class FMLAuditTrail
implements IMixinAuditTrail {
    private static final String APPLY_MIXIN_ACTIVITY = "APP";
    private static final String POST_PROCESS_ACTIVITY = "DEC";
    private static final String GENERATE_ACTIVITY = "GEN";
    private String currentClass;
    private BiConsumer<String, String[]> consumer;

    FMLAuditTrail() {
    }

    public void setConsumer(String className, BiConsumer<String, String[]> consumer) {
        this.currentClass = className;
        this.consumer = consumer;
    }

    public void onApply(String className, String mixinName) {
        this.writeActivity(className, APPLY_MIXIN_ACTIVITY, mixinName);
    }

    public void onPostProcess(String className) {
        this.writeActivity(className, POST_PROCESS_ACTIVITY, new String[0]);
    }

    public void onGenerate(String className, String generatorName) {
        this.writeActivity(className, GENERATE_ACTIVITY, new String[0]);
    }

    private void writeActivity(String className, String activity, String ... context) {
        if (this.consumer != null && className.equals(this.currentClass)) {
            this.consumer.accept(activity, context);
        }
    }
}

