/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.neoforged.fml.jarcontents.JarResourceAttributes;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface JarResource {
    public InputStream open() throws IOException;

    default public BufferedReader bufferedReader() throws IOException {
        return this.bufferedReader(StandardCharsets.UTF_8);
    }

    default public BufferedReader bufferedReader(Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(this.open(), charset));
    }

    default public byte[] readAllBytes() throws IOException {
        try (InputStream stream = this.open();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    public JarResourceAttributes attributes() throws IOException;

    public JarResource retain();
}

