/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import net.neoforged.fml.jarcontents.EmptyManifest;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarcontents.JarResourceVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CompositeJarContents
implements JarContents {
    private final JarContents[] delegates;
    @Nullable
    private final @Nullable JarContents.PathFilter @Nullable [] filters;
    private final List<Path> contentRoots;
    private volatile Optional<String> checksum;

    public CompositeJarContents(List<JarContents> delegates) {
        this(delegates, null);
    }

    public CompositeJarContents(List<JarContents> delegates, @Nullable @Nullable List<@Nullable JarContents.PathFilter> filters) {
        if (delegates.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct an empty mod container");
        }
        if (filters != null && delegates.size() != filters.size()) {
            throw new IllegalArgumentException("The number of delegates and filters must match.");
        }
        if (delegates.size() == 1 && (filters == null || filters.getFirst() == null)) {
            throw new IllegalArgumentException("Can only construct a composite jar contents with multiple delegates or at least one filter.");
        }
        delegates = delegates.reversed();
        filters = filters != null ? filters.reversed() : null;
        this.delegates = (JarContents[])delegates.toArray(JarContents[]::new);
        this.filters = filters != null ? (JarContents.PathFilter[])filters.toArray(JarContents.PathFilter[]::new) : null;
        ArrayList<Path> contentRoots = new ArrayList<Path>();
        for (JarContents delegate : delegates) {
            for (Path root : delegate.getContentRoots()) {
                if (contentRoots.contains(root)) continue;
                contentRoots.add(root);
            }
        }
        this.contentRoots = List.copyOf(contentRoots.reversed());
    }

    @Override
    public Collection<Path> getContentRoots() {
        return this.contentRoots;
    }

    public boolean isFiltered() {
        return this.filters != null && Arrays.stream(this.filters).anyMatch(Objects::nonNull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getChecksum() {
        Optional<String> checksum = this.checksum;
        if (checksum == null) {
            CompositeJarContents compositeJarContents = this;
            synchronized (compositeJarContents) {
                checksum = this.checksum;
                if (checksum == null) {
                    this.checksum = checksum = this.computeChecksum();
                }
            }
        }
        return checksum;
    }

    private Optional<String> computeChecksum() {
        MessageDigest digest;
        if (this.isFiltered()) {
            return Optional.empty();
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        for (JarContents delegate : this.delegates) {
            Optional<String> delegateChecksum = delegate.getChecksum();
            if (delegateChecksum.isEmpty()) {
                return Optional.empty();
            }
            digest.update(delegateChecksum.get().getBytes());
        }
        byte[] checksum = digest.digest();
        return Optional.of(HexFormat.of().formatHex(checksum));
    }

    @Override
    public Path getPrimaryPath() {
        return this.delegates[this.delegates.length - 1].getPrimaryPath();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("composite(");
        for (int i = this.delegates.length - 1; i >= 0; --i) {
            JarContents delegate = this.delegates[i];
            if (this.filters != null && this.filters[i] != null) {
                result.append("filtered(").append(delegate).append(")");
            } else {
                result.append(delegate);
            }
            if (i == 0) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public Optional<URI> findFile(String relativePath) {
        for (int i = 0; i < this.delegates.length; ++i) {
            JarContents delegate;
            Optional<URI> result;
            if (this.isMasked(i, relativePath) || !(result = (delegate = this.delegates[i]).findFile(relativePath)).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public Manifest getManifest() {
        for (int i = 0; i < this.delegates.length; ++i) {
            JarContents delegate;
            Manifest manifest;
            if (this.isMasked(i, "META-INF/MANIFEST.MF") || (manifest = (delegate = this.delegates[i]).getManifest()).getMainAttributes().isEmpty() && manifest.getEntries().isEmpty()) continue;
            return manifest;
        }
        return EmptyManifest.INSTANCE;
    }

    @Override
    @Nullable
    public JarResource get(String relativePath) {
        for (int i = 0; i < this.delegates.length; ++i) {
            JarContents delegate;
            JarResource resource;
            if (this.isMasked(i, relativePath) || (resource = (delegate = this.delegates[i]).get(relativePath)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public boolean containsFile(String relativePath) {
        for (int i = 0; i < this.delegates.length; ++i) {
            JarContents delegate;
            if (this.isMasked(i, relativePath) || !(delegate = this.delegates[i]).containsFile(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream openFile(String relativePath) throws IOException {
        for (int i = 0; i < this.delegates.length; ++i) {
            JarContents delegate;
            InputStream stream;
            if (this.isMasked(i, relativePath) || (stream = (delegate = this.delegates[i]).openFile(relativePath)) == null) continue;
            return stream;
        }
        return null;
    }

    @Override
    public byte[] readFile(String relativePath) throws IOException {
        for (int i = 0; i < this.delegates.length; ++i) {
            JarContents delegate;
            byte[] content;
            if (this.isMasked(i, relativePath) || (content = (delegate = this.delegates[i]).readFile(relativePath)) == null) continue;
            return content;
        }
        return null;
    }

    @Override
    public void visitContent(String startingFolder, final JarResourceVisitor visitor) {
        var distinctVisitor = new JarResourceVisitor(){
            final Set<String> pathsVisited = new HashSet<String>();
            int delegateIdx;

            @Override
            public void visit(String relativePath, JarResource resource) {
                if (!CompositeJarContents.this.isMasked(this.delegateIdx, relativePath) && this.pathsVisited.add(relativePath)) {
                    visitor.visit(relativePath, resource);
                }
            }
        };
        int i = 0;
        while (i < this.delegates.length) {
            JarContents delegate = this.delegates[i];
            distinctVisitor.delegateIdx = i++;
            delegate.visitContent(startingFolder, distinctVisitor);
        }
    }

    @Override
    public void close() throws IOException {
        Throwable error = null;
        for (JarContents delegate : this.delegates) {
            try {
                delegate.close();
            }
            catch (IOException e) {
                if (error == null) {
                    error = new IOException("Failed to close one ore more delegates of " + String.valueOf(this));
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    private boolean isMasked(int delegateIdx, String relativePath) {
        if (this.filters == null) {
            return false;
        }
        JarContents.PathFilter filter = this.filters[delegateIdx];
        return filter != null && !filter.test(relativePath);
    }

    public List<JarContents> getDelegates() {
        return List.of(this.delegates);
    }
}

