/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonServerLaunchHandler
extends CommonLaunchHandler {
    @Override
    public Dist getDist() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public String getNaming() {
        return "srg";
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    @Override
    protected void runService(String[] arguments, ModuleLayer gameLayer) throws Throwable {
        this.serverService(arguments, gameLayer);
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        Stream.Builder<List<Path>> modstream;
        BiPredicate<String, String> filter;
        VersionInfo vers = FMLLoader.versionInfo();
        Path mc = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "srg", vers.mcAndNeoFormVersion());
        Path mcextra = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "extra", vers.mcAndNeoFormVersion());
        SecureJar mcextra_filtered = SecureJar.from((path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/"), (Path[])new Path[]{mcextra});
        BiPredicate<String, String> nullFilter = filter = (path, base) -> true;
        Stream.Builder<Path> mcstream = Stream.builder().add(mc).add(mcextra_filtered.getRootPath());
        filter = this.processMCStream(vers, mcstream, filter, modstream = Stream.builder());
        if (filter == nullFilter) {
            filter = null;
        }
        return new CommonLaunchHandler.LocatedPaths(mcstream.build().toList(), filter, modstream.build().toList(), this.getFmlPaths(this.getLegacyClasspath()));
    }

    protected abstract BiPredicate<String, String> processMCStream(VersionInfo var1, Stream.Builder<Path> var2, BiPredicate<String, String> var3, Stream.Builder<List<Path>> var4);
}

