/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleReader;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FileUtils;
import net.neoforged.fml.loading.LogMarkers;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;

public abstract class CommonLaunchHandler
implements ILaunchHandlerService {
    protected static final Logger LOGGER = LogUtils.getLogger();

    public abstract Dist getDist();

    public abstract String getNaming();

    public boolean isProduction() {
        return false;
    }

    public boolean isData() {
        return false;
    }

    public abstract LocatedPaths getMinecraftPaths();

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
    }

    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        URI uri;
        try (ModuleReader reader = layer.configuration().findModule("fml_loader").orElseThrow().reference().open();){
            uri = reader.find("log4j2.xml").orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Configurator.reconfigure((Configuration)ConfigurationFactory.getInstance().getConfiguration(LoggerContext.getContext(), ConfigurationSource.fromUri((URI)uri)));
        return arguments;
    }

    protected final String[] getLegacyClasspath() {
        return Objects.requireNonNull(System.getProperty("legacyClassPath"), "Missing legacyClassPath, cannot load").split(File.pathSeparator);
    }

    protected final List<Path> getFmlPaths(String[] classpath) {
        String[] fmlLibraries = System.getProperty("fml.pluginLayerLibraries").split(",");
        return Arrays.stream(classpath).filter(e -> FileUtils.matchFileName(e, true, fmlLibraries)).map(x$0 -> Paths.get(x$0, new String[0])).toList();
    }

    protected final Map<String, List<Path>> getModClasses() {
        String modClasses = Optional.ofNullable(System.getenv("MOD_CLASSES")).orElse("");
        LOGGER.debug(LogMarkers.CORE, "Got mod coordinates {} from env", (Object)modClasses);
        record ExplodedModPath(String modid, Path path) {
        }
        Map<String, List<Path>> modClassPaths = Arrays.stream(modClasses.split(File.pathSeparator)).map(inp -> inp.split("%%", 2)).map(splitString -> new ExplodedModPath(((String[])splitString).length == 1 ? "defaultmodid" : splitString[0], Paths.get(splitString[((String[])splitString).length - 1], new String[0]))).collect(Collectors.groupingBy(ExplodedModPath::modid, Collectors.mapping(ExplodedModPath::path, Collectors.toList())));
        LOGGER.debug(LogMarkers.CORE, "Found supplied mod coordinates [{}]", modClassPaths);
        return modClassPaths;
    }

    public ServiceRunner launchService(String[] arguments, ModuleLayer gameLayer) {
        FMLLoader.beforeStart(gameLayer);
        String[] args = this.preLaunch(arguments, gameLayer);
        return () -> this.runService(args, gameLayer);
    }

    protected abstract void runService(String[] var1, ModuleLayer var2) throws Throwable;

    protected void clientService(String[] arguments, ModuleLayer layer) throws Throwable {
        this.runTarget("net.minecraft.client.main.Main", arguments, layer);
    }

    protected void serverService(String[] arguments, ModuleLayer layer) throws Throwable {
        this.runTarget("net.minecraft.server.Main", arguments, layer);
    }

    protected void dataService(String[] arguments, ModuleLayer layer) throws Throwable {
        this.runTarget("net.minecraft.data.Main", arguments, layer);
    }

    protected void runTarget(String target, String[] arguments, ModuleLayer layer) throws Throwable {
        Class.forName(layer.findModule("minecraft").orElseThrow(), target).getMethod("main", String[].class).invoke(null, new Object[]{arguments});
    }

    public record LocatedPaths(List<Path> minecraftPaths, BiPredicate<String, String> minecraftFilter, List<List<Path>> otherModPaths, List<Path> otherArtifacts) {
    }
}

