/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.neoforged.fml.loading.moddiscovery.AbstractJarFileModProvider;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.ModFileLoadingException;
import org.slf4j.Logger;

public abstract class AbstractJarFileDependencyLocator
extends AbstractJarFileModProvider
implements IDependencyLocator {
    private static final Logger LOGGER = LogUtils.getLogger();

    protected Optional<InputStream> loadResourceFromModFile(IModFile modFile, Path path) {
        try {
            return Optional.of(Files.newInputStream(modFile.findResource(new String[]{path.toString()}), new OpenOption[0]));
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Failed to load resource {} from {}, it does not contain dependency information.", (Object)path, (Object)modFile.getFileName());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load resource {} from mod {}, cause {}", new Object[]{path, modFile.getFileName(), e});
            return Optional.empty();
        }
    }

    protected Optional<IModFile> loadModFileFrom(IModFile file, Path path) {
        try {
            Path pathInModFile = file.findResource(new String[]{path.toString()});
            return Optional.of(this.createMod(pathInModFile).file());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load mod file {} from {}", (Object)path, (Object)file.getFileName());
            throw new ModFileLoadingException("Failed to load mod file " + file.getFileName());
        }
    }

    protected String identifyMod(IModFile modFile) {
        return modFile.getFileName();
    }
}

