/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.lowcodemod;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.neoforgespi.language.ILifecycleEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageProvider;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LowCodeModLanguageProvider
implements IModLanguageProvider {
    public String name() {
        return "lowcodefml";
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        return scanResult -> {
            Map modTargetMap = scanResult.getIModInfoData().stream().flatMap(fi -> fi.getMods().stream()).map(IModInfo::getModId).map(LowCodeModTarget::new).collect(Collectors.toMap(LowCodeModTarget::modId, Function.identity(), (a, b) -> a));
            scanResult.addLanguageLoader(modTargetMap);
        };
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> consumeEvent) {
    }

    private record LowCodeModTarget(String modId) implements IModLanguageProvider.IModLanguageLoader
    {
        private static final Logger LOGGER = LogManager.getLogger();

        public <T> T loadMod(IModInfo info, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
            try {
                Class<?> fmlContainer = Class.forName("net.neoforged.fml.lowcodemod.LowCodeModContainer", true, Thread.currentThread().getContextClassLoader());
                LOGGER.debug(Logging.LOADING, "Loading LowCodeModContainer from classloader {} - got {}", (Object)Thread.currentThread().getContextClassLoader(), (Object)fmlContainer.getClassLoader());
                Constructor<?> constructor = fmlContainer.getConstructor(IModInfo.class, ModFileScanData.class, ModuleLayer.class);
                return (T)constructor.newInstance(info, modFileScanResults, gameLayer);
            }
            catch (InvocationTargetException e) {
                LOGGER.fatal(Logging.LOADING, "Failed to build mod", (Throwable)e);
                Throwable throwable = e.getTargetException();
                if (throwable instanceof ModLoadingException) {
                    ModLoadingException mle = (ModLoadingException)throwable;
                    throw mle;
                }
                throw new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", (Throwable)e, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                LOGGER.fatal(Logging.LOADING, "Unable to load LowCodeModContainer, wut?", (Throwable)e);
                Class mle = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.neoforged.fml.ModLoadingException", true, Thread.currentThread().getContextClassLoader()));
                Class mls = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.neoforged.fml.ModLoadingStage", true, Thread.currentThread().getContextClassLoader()));
                throw (RuntimeException)LamdbaExceptionUtils.uncheck(() -> (RuntimeException)((Constructor)LamdbaExceptionUtils.uncheck(() -> mle.getConstructor(IModInfo.class, mls, String.class, Throwable.class))).newInstance(info, Enum.valueOf(mls, "CONSTRUCT"), "fml.modloading.failedtoloadmodclass", e));
            }
        }
    }
}

