/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.javafmlmod;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.EventBusErrorMessage;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.javafmlmod.AutomaticEventSubscriber;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;

public class FMLModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker LOADING = MarkerManager.getMarker((String)"LOADING");
    private final ModFileScanData scanResults;
    private final IEventBus eventBus;
    private Object modInstance;
    private final Class<?> modClass;

    public FMLModContainer(IModInfo info, String className, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
        super(info);
        LOGGER.debug(LOADING, "Creating FMLModContainer instance for {}", (Object)className);
        this.scanResults = modFileScanResults;
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).markerType(IModBusEvent.class).build();
        this.configHandler = Optional.of(ce -> this.eventBus.post(ce.self()));
        FMLJavaModLoadingContext contextExtension = new FMLJavaModLoadingContext(this);
        this.contextExtension = () -> contextExtension;
        try {
            Module layer = gameLayer.findModule(info.getOwningFile().moduleName()).orElseThrow();
            this.modClass = Class.forName(layer, className);
            LOGGER.trace(LOADING, "Loaded modclass {} with {}", (Object)this.modClass.getName(), (Object)this.modClass.getClassLoader());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to load class {}", (Object)className, (Object)e);
            throw new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", e, new Object[0]);
        }
    }

    private void onEventFailed(IEventBus iEventBus, Event event, EventListener[] iEventListeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, iEventListeners, throwable));
    }

    private void constructMod() {
        try {
            LOGGER.trace(LOADING, "Loading mod instance {} of type {}", (Object)this.getModId(), (Object)this.modClass.getName());
            Constructor<?>[] constructors = this.modClass.getConstructors();
            if (constructors.length != 1) {
                throw new RuntimeException("Mod class must have exactly 1 public constructor, found " + constructors.length);
            }
            Constructor<?> constructor = constructors[0];
            Map<Class<Dist>, Dist> allowedConstructorArgs = Map.of(IEventBus.class, this.eventBus, ModContainer.class, this, FMLModContainer.class, this, Dist.class, FMLLoader.getDist());
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] constructorArgs = new Object[parameterTypes.length];
            HashSet foundArgs = new HashSet();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Dist argInstance = allowedConstructorArgs.get(parameterTypes[i]);
                if (argInstance == null) {
                    throw new RuntimeException("Mod constructor has unsupported argument " + parameterTypes[i] + ". Allowed optional argument classes: " + allowedConstructorArgs.keySet().stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
                }
                if (foundArgs.contains(parameterTypes[i])) {
                    throw new RuntimeException("Duplicate mod constructor argument type: " + parameterTypes[i]);
                }
                foundArgs.add(parameterTypes[i]);
                constructorArgs[i] = argInstance;
            }
            this.modInstance = constructor.newInstance(constructorArgs);
            LOGGER.trace(LOADING, "Loaded mod instance {} of type {}", (Object)this.getModId(), (Object)this.modClass.getName());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            LOGGER.error(LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
        try {
            LOGGER.trace(LOADING, "Injecting Automatic event subscribers for {}", (Object)this.getModId());
            AutomaticEventSubscriber.inject(this, this.scanResults, this.modClass.getClassLoader());
            LOGGER.trace(LOADING, "Completed Automatic event subscribers for {}", (Object)this.getModId());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to register automatic subscribers. ModID: {}, class {}", (Object)this.getModId(), (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
    }

    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    public Object getMod() {
        return this.modInstance;
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    protected <T extends Event> void acceptEvent(T e) {
        try {
            LOGGER.trace(LOADING, "Firing event for modid {} : {}", (Object)this.getModId(), e);
            this.eventBus.post(e);
            LOGGER.trace(LOADING, "Fired event for modid {} : {}", (Object)this.getModId(), e);
        }
        catch (Throwable t) {
            LOGGER.error(LOADING, "Caught exception during event {} dispatch for modid {}", e, (Object)this.getModId(), (Object)t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }
}

