/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.junit;

import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.startup.JUnitGameBootstrapper;
import net.neoforged.fml.startup.StartupArgs;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitService
implements LauncherSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(JUnitService.class);
    private static final Namespace NAMESPACE = Namespace.create((Object[])new Object[]{"fml", "junit"});
    static final String KEY_ACTIVE_LOADER = "activeLoader";

    public void launcherSessionOpened(LauncherSession session) {
        NamespacedHierarchicalStore store = session.getStore();
        ActivatedLoader loader = (ActivatedLoader)store.getOrComputeIfAbsent((Object)NAMESPACE, (Object)KEY_ACTIVE_LOADER, ignored -> this.createLoader(), ActivatedLoader.class);
        LOG.info("Active FML loader {}", (Object)Integer.toHexString(System.identityHashCode(loader.loader)));
    }

    public void launcherSessionClosed(LauncherSession session) {
        ActivatedLoader loader = (ActivatedLoader)session.getStore().remove((Object)NAMESPACE, (Object)KEY_ACTIVE_LOADER, ActivatedLoader.class);
        if (loader != null) {
            loader.close();
        }
    }

    private ActivatedLoader createLoader() {
        ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
        long fmlStart = System.nanoTime();
        StartupArgs startupArgs = new StartupArgs(Path.of("", new String[0]), true, Dist.DEDICATED_SERVER, false, new String[0], Set.of(), List.of(), previousLoader);
        FMLLoader loader = FMLLoader.create((StartupArgs)startupArgs);
        LOG.info("Starting FML took {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - fmlStart));
        if (loader.getLoadingModList().hasErrors()) {
            throw new ModLoadingException(loader.getLoadingModList().getModLoadingIssues());
        }
        for (JUnitGameBootstrapper bootstrapper : ServiceLoader.load(JUnitGameBootstrapper.class, loader.getCurrentClassLoader())) {
            long bootstrapStart = System.nanoTime();
            bootstrapper.bootstrap(loader);
            LOG.info("Running game bootstrapper {} took {}ms", (Object)bootstrapper.getClass().getName(), (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - bootstrapStart));
        }
        return new ActivatedLoader(previousLoader, loader);
    }

    record ActivatedLoader(ClassLoader previousLoader, FMLLoader loader) implements AutoCloseable
    {
        @Override
        public void close() {
            this.loader.close();
            Thread.currentThread().setContextClassLoader(this.previousLoader);
        }
    }
}

