/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.util.List;
import net.neoforged.fml.earlydisplay.render.ElementShader;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.render.MaterializedTheme;
import net.neoforged.fml.earlydisplay.render.MaterializedThemeSprites;
import net.neoforged.fml.earlydisplay.render.QuadHelper;
import net.neoforged.fml.earlydisplay.render.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.theme.ThemeColor;
import net.neoforged.fml.earlydisplay.util.Bounds;

public record RenderContext(SimpleBufferBuilder sharedBuffer, MaterializedTheme theme, float availableWidth, float availableHeight, int animationFrame) {
    public ElementShader bindShader(String shaderId) {
        ElementShader shader = this.theme.getShader(shaderId);
        shader.activate();
        return shader;
    }

    public void blitTexture(Texture texture, Bounds bounds) {
        this.blitTexture(texture, bounds, -1);
    }

    public void blitTexture(Texture texture, Bounds bounds, int color) {
        this.blitTexture(texture, bounds.left(), bounds.top(), bounds.width(), bounds.height(), color);
    }

    public void blitTexture(Texture texture, float x, float y, float width, float height) {
        this.blitTexture(texture, x, y, width, height, -1);
    }

    public void blitTexture(Texture texture, float x, float y, float width, float height, int color) {
        this.blitTextureRegion(texture, x, y, width, height, color, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public void blitTextureRegion(Texture texture, float x, float y, float width, float height, int color, float u0, float u1, float v0, float v1) {
        GlState.activeTexture(33984);
        GlState.bindTexture2D(texture.textureId());
        ElementShader shader = this.bindShader("gui");
        shader.setUniform1i("tex", 0);
        this.sharedBuffer.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        QuadHelper.fillSprite(this.sharedBuffer, texture, x, y, 0.0f, width, height, color, QuadHelper.SpriteFillDirection.TOP_TO_BOTTOM, this.animationFrame, u0, u1, v0, v1);
        this.sharedBuffer.draw();
    }

    public void renderText(float x, float y, SimpleFont font, List<SimpleFont.DisplayText> texts) {
        GlState.activeTexture(33984);
        GlState.bindTexture2D(font.textureId());
        this.bindShader("font");
        this.sharedBuffer.begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        font.generateVerticesForTexts(x, y, this.sharedBuffer, texts);
        this.sharedBuffer.draw();
    }

    public void renderIndeterminateProgressBar(Bounds backgroundBounds) {
        MaterializedThemeSprites sprites = this.theme.sprites();
        this.blitTexture(sprites.progressBarBackground(), backgroundBounds);
        if (this.theme.theme().sprites().progressBarIndeterminateBounces()) {
            int barX = 0;
            int barWidth = (int)(backgroundBounds.width() * 0.2f);
            int availableSpace = (int)(backgroundBounds.width() - (float)barWidth);
            if (availableSpace > 0) {
                float f = (float)(this.animationFrame() % 200) / 100.0f;
                if (f > 1.0f) {
                    f = 1.0f - (f - 1.0f);
                }
                barX = (int)(f * (float)availableSpace);
            }
            this.blitTexture(sprites.progressBarIndeterminate(), backgroundBounds.left() + (float)barX, backgroundBounds.top(), barWidth, backgroundBounds.height());
        } else {
            int centerPercentage = this.animationFrame() % 120 - 10;
            float start = Math.clamp((float)(centerPercentage - 10) / 100.0f, 0.0f, 1.0f);
            float end = Math.clamp((float)(centerPercentage + 10) / 100.0f, 0.0f, 1.0f);
            this.blitTexture(sprites.progressBarIndeterminate(), (int)(backgroundBounds.left() + backgroundBounds.width() * start), backgroundBounds.top(), (int)(backgroundBounds.width() * (end - start)), backgroundBounds.height());
        }
    }

    public void renderProgressBar(Bounds barBounds, float fillFactor) {
        this.renderProgressBar(barBounds, fillFactor, ThemeColor.WHITE.toArgb());
    }

    public void renderProgressBar(Bounds barBounds, float fillFactor, int foregroundColor) {
        fillFactor = Math.clamp(fillFactor, 0.0f, 1.0f);
        MaterializedThemeSprites sprites = this.theme.sprites();
        this.blitTexture(sprites.progressBarBackground(), barBounds);
        GlState.scissorTest(true);
        GlState.scissorBox((int)barBounds.left(), (int)barBounds.top(), (int)(barBounds.width() * fillFactor), (int)barBounds.height());
        this.blitTexture(sprites.progressBarForeground(), barBounds, foregroundColor);
        GlState.scissorTest(false);
    }
}

