/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.nio.IntBuffer;
import net.neoforged.fml.earlydisplay.render.GlDebug;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.render.elements.RenderElement;
import net.neoforged.fml.earlydisplay.theme.ThemeColor;
import org.lwjgl.opengl.GL32C;

public class EarlyFramebuffer {
    private final int framebuffer;
    private final int texture;
    private int width;
    private int height;

    EarlyFramebuffer(int width, int height) {
        this.width = width;
        this.height = height;
        this.framebuffer = GL32C.glGenFramebuffers();
        this.texture = GL32C.glGenTextures();
        GlState.bindFramebuffer(this.framebuffer);
        GlDebug.labelFramebuffer(this.framebuffer, "EarlyDisplay framebuffer");
        GlState.activeTexture(33984);
        GlState.bindTexture2D(this.texture);
        GlDebug.labelTexture(this.texture, "EarlyDisplay backbuffer");
        GL32C.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        GL32C.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL32C.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL32C.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        GlState.bindFramebuffer(0);
    }

    void activate() {
        GlState.bindFramebuffer(this.framebuffer);
    }

    void deactivate() {
        GlState.bindFramebuffer(0);
    }

    void blitToScreen(ThemeColor backgroundColor, int windowFBWidth, int windowFBHeight) {
        float wscale = (float)windowFBWidth / (float)this.width;
        float hscale = (float)windowFBHeight / (float)this.height;
        float scale = Math.min(wscale, hscale) / 2.0f;
        int wleft = (int)((float)windowFBWidth * 0.5f - scale * (float)this.width);
        int wtop = (int)((float)windowFBHeight * 0.5f - scale * (float)this.height);
        int wright = (int)((float)windowFBWidth * 0.5f + scale * (float)this.width);
        int wbottom = (int)((float)windowFBHeight * 0.5f + scale * (float)this.height);
        GlState.bindDrawFramebuffer(0);
        GlState.bindReadFramebuffer(this.framebuffer);
        GlState.clearColor(backgroundColor.r(), backgroundColor.g(), backgroundColor.b(), 1.0f);
        GL32C.glClear((int)16384);
        GL32C.glBlitFramebuffer((int)0, (int)this.height, (int)this.width, (int)0, (int)RenderElement.clamp(wleft, 0, windowFBWidth), (int)RenderElement.clamp(wtop, 0, windowFBHeight), (int)RenderElement.clamp(wright, 0, windowFBWidth), (int)RenderElement.clamp(wbottom, 0, windowFBHeight), (int)16384, (int)9728);
        GlState.bindFramebuffer(0);
    }

    int getTexture() {
        return this.texture;
    }

    public void resize(int width, int height) {
        if (this.width != width || this.height != height) {
            GlState.bindFramebuffer(this.framebuffer);
            this.width = width;
            this.height = height;
            GL32C.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        }
    }

    public void close() {
        GL32C.glDeleteTextures((int)this.texture);
        GL32C.glDeleteFramebuffers((int)this.framebuffer);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

