/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.neoforged.fml.earlydisplay.render.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.theme.TextureScaling;
import net.neoforged.fml.earlydisplay.util.Bounds;

class QuadHelper {
    QuadHelper() {
    }

    public static void fillSprite(SimpleBufferBuilder buffer, Texture texture, float x, float y, float z, float width, float height, int color, SpriteFillDirection fillDirection, int animationFrame, float srcU0, float srcU1, float srcV0, float srcV1) {
        width = Math.min(65535.0f, width);
        height = Math.min(65535.0f, height);
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        if (texture.animationMetadata() != null) {
            int frameCount = texture.animationMetadata().frameCount();
            int frameHeight = texture.physicalHeight() / frameCount;
            float vUnit = (float)frameHeight / (float)texture.physicalHeight();
            v0 = (float)(animationFrame % frameCount) * vUnit;
            v1 = (float)(animationFrame % frameCount + 1) * vUnit;
        }
        float w = u1 - u0;
        u1 = u0 + w * srcU1;
        u0 += w * srcU0;
        float h = v1 - v0;
        v1 = v0 + h * srcV1;
        v0 += h * srcV0;
        TextureScaling textureScaling = texture.scaling();
        Objects.requireNonNull(textureScaling);
        TextureScaling textureScaling2 = textureScaling;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextureScaling.Tile.class, TextureScaling.Stretch.class, TextureScaling.NineSlice.class}, (Object)textureScaling2, n)) {
            case 0: {
                TextureScaling.Tile tiled = (TextureScaling.Tile)textureScaling2;
                QuadHelper.fillTiled(buffer, x, y, z, width, height, color, tiled.width(), tiled.height(), u0, u1, v0, v1, fillDirection);
                break;
            }
            case 1: {
                TextureScaling.Stretch stretch = (TextureScaling.Stretch)textureScaling2;
                QuadHelper.addQuad(buffer, x, y, z, width, height, color, u0, u1, v0, v1);
                break;
            }
            case 2: {
                TextureScaling.NineSlice nineSlice = (TextureScaling.NineSlice)textureScaling2;
                QuadHelper.addTiledNineSlice(buffer, x, y, z, width, height, color, nineSlice, u0, u1, v0, v1);
                break;
            }
        }
    }

    private static void addTiledNineSlice(SimpleBufferBuilder buffer, float x, float y, float z, float width, float height, int color, TextureScaling.NineSlice nineSlice, float u0, float u1, float v0, float v1) {
        float leftWidth = Math.min((float)nineSlice.left(), width / 2.0f);
        float rightWidth = Math.min((float)nineSlice.right(), width / 2.0f);
        float topHeight = Math.min((float)nineSlice.top(), height / 2.0f);
        float bottomHeight = Math.min((float)nineSlice.bottom(), height / 2.0f);
        int innerWidth = nineSlice.width() - nineSlice.left() - nineSlice.right();
        int innerHeight = nineSlice.height() - nineSlice.top() - nineSlice.bottom();
        float leftU = u0 + leftWidth / (float)nineSlice.width() * (u1 - u0);
        float rightU = u1 - rightWidth / (float)nineSlice.width() * (u1 - u0);
        float topV = v0 + topHeight / (float)nineSlice.height() * (v1 - v0);
        float bottomV = v1 - bottomHeight / (float)nineSlice.height() * (v1 - v0);
        float dstInnerLeft = x + leftWidth;
        float dstInnerTop = y + topHeight;
        float dstInnerRight = x + width - rightWidth;
        float dstInnerBottom = y + height - bottomHeight;
        float dstInnerWidth = dstInnerRight - dstInnerLeft;
        float dstInnerHeight = dstInnerBottom - dstInnerTop;
        QuadHelper.addQuad(buffer, x, y, z, leftWidth, topHeight, color, u0, leftU, v0, topV);
        QuadHelper.addQuad(buffer, dstInnerRight, y, z, rightWidth, topHeight, color, rightU, u1, v0, topV);
        QuadHelper.addQuad(buffer, dstInnerRight, dstInnerBottom, z, rightWidth, bottomHeight, color, rightU, u1, bottomV, v1);
        QuadHelper.addQuad(buffer, x, dstInnerBottom, z, leftWidth, bottomHeight, color, u0, leftU, bottomV, v1);
        if (nineSlice.stretchHorizontalFill()) {
            QuadHelper.addQuad(buffer, dstInnerLeft, y, z, dstInnerWidth, topHeight, color, leftU, rightU, v0, topV);
            QuadHelper.addQuad(buffer, dstInnerLeft, dstInnerBottom, z, dstInnerWidth, bottomHeight, color, leftU, rightU, bottomV, v1);
        } else {
            QuadHelper.fillTiled(buffer, dstInnerLeft, y, z, dstInnerWidth, topHeight, color, innerWidth, nineSlice.top(), leftU, rightU, v0, topV);
            QuadHelper.fillTiled(buffer, dstInnerLeft, dstInnerBottom, z, dstInnerWidth, bottomHeight, color, innerWidth, nineSlice.bottom(), leftU, rightU, bottomV, v1);
        }
        if (nineSlice.stretchVerticalFill()) {
            QuadHelper.addQuad(buffer, x, dstInnerTop, z, leftWidth, dstInnerHeight, color, u0, leftU, topV, bottomV);
            QuadHelper.addQuad(buffer, dstInnerRight, dstInnerTop, z, rightWidth, dstInnerHeight, color, rightU, u1, topV, bottomV);
        } else {
            QuadHelper.fillTiled(buffer, x, dstInnerTop, z, leftWidth, dstInnerHeight, color, nineSlice.left(), innerHeight, u0, leftU, topV, bottomV);
            QuadHelper.fillTiled(buffer, dstInnerRight, dstInnerTop, z, rightWidth, dstInnerHeight, color, nineSlice.right(), innerHeight, rightU, u1, topV, bottomV);
        }
        if (nineSlice.stretchHorizontalFill() && nineSlice.stretchVerticalFill()) {
            QuadHelper.addQuad(buffer, dstInnerLeft, dstInnerTop, z, dstInnerWidth, dstInnerHeight, color, leftU, rightU, topV, bottomV);
        } else if (nineSlice.stretchHorizontalFill()) {
            QuadHelper.fillTiled(buffer, dstInnerLeft, dstInnerTop, z, dstInnerWidth, dstInnerHeight, color, dstInnerWidth, innerHeight, leftU, rightU, topV, bottomV);
        } else if (nineSlice.stretchVerticalFill()) {
            QuadHelper.fillTiled(buffer, dstInnerLeft, dstInnerTop, z, dstInnerWidth, dstInnerHeight, color, innerWidth, dstInnerHeight, leftU, rightU, topV, bottomV);
        } else {
            QuadHelper.fillTiled(buffer, dstInnerLeft, dstInnerTop, z, dstInnerWidth, dstInnerHeight, color, innerWidth, innerHeight, leftU, rightU, topV, bottomV);
        }
    }

    private static void fillTiled(SimpleBufferBuilder buffer, float x, float y, float z, float width, float height, int color, float destTileWidth, float destTileHeight, float u0, float u1, float v0, float v1) {
        QuadHelper.fillTiled(buffer, x, y, z, width, height, color, destTileWidth, destTileHeight, u0, u1, v0, v1, SpriteFillDirection.TOP_TO_BOTTOM);
    }

    private static void fillTiled(SimpleBufferBuilder buffer, float x, float y, float z, float width, float height, int color, float destTileWidth, float destTileHeight, float u0, float u1, float v0, float v1, SpriteFillDirection fillDirection) {
        if (destTileWidth <= 0.0f || destTileHeight <= 0.0f) {
            return;
        }
        float right = x + width;
        float bottom = y + height;
        if (fillDirection == SpriteFillDirection.BOTTOM_TO_TOP) {
            for (float cy = bottom; cy >= y; cy -= destTileHeight) {
                float tileHeight = Math.min(cy - y, destTileHeight);
                float tileV0 = v1 - (v1 - v0) * tileHeight / destTileHeight;
                for (float cx = x; cx < right; cx += destTileWidth) {
                    float tileWidth = Math.min(right - cx, destTileWidth);
                    float tileU1 = u0 + (u1 - u0) * tileWidth / destTileWidth;
                    QuadHelper.addQuad(buffer, cx, cy - tileHeight, z, tileWidth, tileHeight, color, u0, tileU1, tileV0, v1);
                }
            }
        } else {
            for (float cy = y; cy < bottom; cy += destTileHeight) {
                float tileHeight = Math.min(bottom - cy, destTileHeight);
                float tileV1 = v0 + (v1 - v0) * tileHeight / destTileHeight;
                for (float cx = x; cx < right; cx += destTileWidth) {
                    float tileWidth = Math.min(right - cx, destTileWidth);
                    float tileU1 = u0 + (u1 - u0) * tileWidth / destTileWidth;
                    QuadHelper.addQuad(buffer, cx, cy, z, tileWidth, tileHeight, color, u0, tileU1, v0, tileV1);
                }
            }
        }
    }

    public static void addQuad(SimpleBufferBuilder buffer, float x, float y, float z, float width, float height, int color, float minU, float maxU, float minV, float maxV) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        QuadHelper.loadQuad(buffer, x, x + width, y, y + height, minU, maxU, minV, maxV, color);
    }

    public static void loadQuad(SimpleBufferBuilder bb, Bounds bounds, float u0, float u1, float v0, float v1, int colour) {
        QuadHelper.loadQuad(bb, bounds.left(), bounds.right(), bounds.top(), bounds.bottom(), u0, u1, v0, v1, colour);
    }

    public static void loadQuad(SimpleBufferBuilder bb, float x0, float x1, float y0, float y1, float u0, float u1, float v0, float v1, int colour) {
        bb.pos(x0, y0).tex(u0, v0).colour(colour).endVertex();
        bb.pos(x1, y0).tex(u1, v0).colour(colour).endVertex();
        bb.pos(x0, y1).tex(u0, v1).colour(colour).endVertex();
        bb.pos(x1, y1).tex(u1, v1).colour(colour).endVertex();
    }

    public static void loadQuad(SimpleBufferBuilder bb, float x0, float x1, float y0, float y1, float u0, float u1, float v0, float v1) {
        bb.pos(x0, y0).tex(u0, v0).endVertex();
        bb.pos(x1, y0).tex(u1, v0).endVertex();
        bb.pos(x0, y1).tex(u0, v1).endVertex();
        bb.pos(x1, y1).tex(u1, v1).endVertex();
    }

    public static enum SpriteFillDirection {
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }
}

