/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.fml.earlydisplay.render.ElementShader;
import net.neoforged.fml.earlydisplay.render.MaterializedThemeSprites;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import net.neoforged.fml.earlydisplay.render.Texture;
import net.neoforged.fml.earlydisplay.theme.Theme;
import net.neoforged.fml.earlydisplay.theme.ThemeResource;
import net.neoforged.fml.earlydisplay.theme.ThemeShader;
import net.neoforged.fml.earlydisplay.theme.ThemeSprites;
import org.jetbrains.annotations.Nullable;

public record MaterializedTheme(Theme theme, @Nullable Path externalThemeDirectory, Map<String, SimpleFont> fonts, Map<String, ElementShader> shaders, MaterializedThemeSprites sprites) implements AutoCloseable
{
    public static MaterializedTheme materialize(Theme theme, @Nullable Path externalThemeDirectory) {
        return new MaterializedTheme(theme, externalThemeDirectory, MaterializedTheme.loadFonts(theme.fonts(), externalThemeDirectory), MaterializedTheme.loadShaders(theme.shaders(), externalThemeDirectory), MaterializedTheme.loadSprites(theme.sprites(), externalThemeDirectory));
    }

    private static Map<String, ElementShader> loadShaders(Map<String, ThemeShader> themeShaders, @Nullable Path externalThemeDirectory) {
        HashMap<String, ElementShader> shaders = new HashMap<String, ElementShader>(themeShaders.size());
        for (Map.Entry<String, ThemeShader> entry : themeShaders.entrySet()) {
            ElementShader shader = ElementShader.create(entry.getKey(), entry.getValue().vertexShader(), entry.getValue().fragmentShader(), externalThemeDirectory);
            shaders.put(entry.getKey(), shader);
        }
        return shaders;
    }

    private static Map<String, SimpleFont> loadFonts(Map<String, ThemeResource> themeFonts, @Nullable Path externalThemeDirectory) {
        HashMap<String, SimpleFont> fonts = new HashMap<String, SimpleFont>(themeFonts.size());
        for (Map.Entry<String, ThemeResource> entry : themeFonts.entrySet()) {
            try {
                fonts.put(entry.getKey(), new SimpleFont(entry.getValue(), externalThemeDirectory));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load font " + entry.getKey(), e);
            }
        }
        return fonts;
    }

    private static MaterializedThemeSprites loadSprites(ThemeSprites sprites, @Nullable Path externalThemeDirectory) {
        return new MaterializedThemeSprites(Texture.create(sprites.progressBarBackground(), externalThemeDirectory), Texture.create(sprites.progressBarForeground(), externalThemeDirectory), Texture.create(sprites.progressBarIndeterminate(), externalThemeDirectory));
    }

    public SimpleFont getFont(String fontId) {
        SimpleFont font = this.fonts.getOrDefault(fontId, this.fonts.get("default"));
        if (font == null) {
            throw new IllegalStateException("Theme does not contain a default font. Available fonts: " + String.valueOf(this.fonts.keySet()));
        }
        return font;
    }

    public ElementShader getShader(String shaderId) {
        ElementShader shader = this.shaders.get(shaderId);
        if (shader == null) {
            throw new IllegalArgumentException("Missing shader definition in theme for " + shaderId);
        }
        return shader;
    }

    @Override
    public void close() {
        this.shaders.values().forEach(ElementShader::close);
    }
}

