/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.util;

import net.neoforged.fml.earlydisplay.util.Size;

public record Bounds(float left, float top, float right, float bottom) {
    public Bounds(float x, float y, Size size) {
        this(x, y, x + size.width(), y + size.height());
    }

    public float width() {
        return this.right - this.left;
    }

    public float height() {
        return this.bottom - this.top;
    }

    public float horizontalCenter() {
        return (this.right + this.left) / 2.0f;
    }

    public Bounds union(Bounds other) {
        return new Bounds(Math.min(this.left, other.left), Math.min(this.top, other.top), Math.max(this.right, other.right), Math.max(this.bottom, other.bottom));
    }

    public Bounds deflate(float inset) {
        return new Bounds(this.left + inset, this.top + inset, this.right - inset, this.bottom - inset);
    }
}

