/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import net.neoforged.fml.earlydisplay.render.GlDebug;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.theme.AnimationMetadata;
import net.neoforged.fml.earlydisplay.theme.TextureScaling;
import net.neoforged.fml.earlydisplay.theme.ThemeTexture;
import net.neoforged.fml.earlydisplay.theme.UncompressedImage;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL32C;

public record Texture(int textureId, int physicalWidth, int physicalHeight, TextureScaling scaling, @Nullable AnimationMetadata animationMetadata) implements AutoCloseable
{
    public int width() {
        return this.scaling.width();
    }

    public int height() {
        return this.scaling.height();
    }

    public static Texture create(ThemeTexture themeTexture, @Nullable Path externalThemeDirectory) {
        try (UncompressedImage image = themeTexture.resource().loadAsImage(externalThemeDirectory);){
            Texture texture = Texture.create(image, "EarlyDisplay " + String.valueOf(themeTexture), themeTexture.scaling(), themeTexture.animation());
            return texture;
        }
    }

    public static Texture create(UncompressedImage image, String debugName, TextureScaling scaling, @Nullable AnimationMetadata animation) {
        int texId = GL11C.glGenTextures();
        GlState.bindTexture2D(texId);
        GlDebug.labelTexture(texId, debugName);
        boolean linear = scaling.linearScaling();
        GL11C.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11C.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11C.glTexParameteri((int)3553, (int)10240, (int)(linear ? 9729 : 9728));
        GL11C.glTexParameteri((int)3553, (int)10241, (int)(linear ? 9729 : 9728));
        GL11C.glTexImage2D((int)3553, (int)0, (int)6408, (int)image.width(), (int)image.height(), (int)0, (int)6408, (int)5121, (ByteBuffer)image.imageData());
        return new Texture(texId, image.width(), image.height(), scaling, animation);
    }

    @Override
    public void close() {
        GL32C.glDeleteTextures((int)this.textureId);
    }
}

