/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.render;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.IntFunction;
import net.neoforged.fml.earlydisplay.render.GlDebug;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.render.SimpleBufferBuilder;
import net.neoforged.fml.earlydisplay.theme.NativeBuffer;
import net.neoforged.fml.earlydisplay.theme.ThemeResource;
import net.neoforged.fml.earlydisplay.util.Size;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.stb.STBTTAlignedQuad;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTTPackContext;
import org.lwjgl.stb.STBTTPackRange;
import org.lwjgl.stb.STBTTPackedchar;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.Struct;

public class SimpleFont
implements AutoCloseable {
    private static final int ASCII_GLYPH_COUNT = 95;
    private int textureId;
    private final int lineSpacing;
    private final int descent;
    private final IntFunction<Glyph> glyphGetter;

    public Size measureText(CharSequence text) {
        float width = 0.0f;
        float height = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        PrimitiveIterator.OfInt codePoints = text.codePoints().iterator();
        block4: while (codePoints.hasNext()) {
            int codePoint = codePoints.nextInt();
            switch (codePoint) {
                case 10: {
                    width = Math.max(width, x);
                    x = 0.0f;
                    y += (float)this.lineSpacing();
                    continue block4;
                }
                case 9: {
                    x += (float)(this.getSpaceGlyph().charwidth() * 4);
                    continue block4;
                }
            }
            Glyph glyph = this.getGlyph(codePoint);
            if (glyph == null) continue;
            x += (float)glyph.charwidth();
        }
        width = Math.max(width, x);
        height = y + (float)this.descent();
        if (x > 0.0f) {
            height += (float)this.lineSpacing;
        }
        return new Size(width, height);
    }

    @Override
    public void close() {
        if (this.textureId != 0) {
            GL32C.glDeleteTextures((int)this.textureId);
            this.textureId = 0;
        }
    }

    public SimpleFont(int lineSpacing, int descent, int textureId, IntFunction<Glyph> glyphGetter) {
        this.lineSpacing = lineSpacing;
        this.descent = descent;
        this.textureId = textureId;
        this.glyphGetter = glyphGetter;
    }

    public SimpleFont(ThemeResource resource, @Nullable Path externalThemeDirectory) throws IOException {
        try (NativeBuffer nativeBuffer = resource.toNativeBuffer(externalThemeDirectory);){
            ByteBuffer buf = nativeBuffer.buffer();
            STBTTFontinfo info = STBTTFontinfo.create();
            if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)info, (ByteBuffer)buf)) {
                throw new IllegalStateException("Bad font");
            }
            float[] ascent = new float[1];
            float[] descent = new float[1];
            float[] lineGap = new float[1];
            int fontSize = 24;
            STBTruetype.stbtt_GetScaledFontVMetrics((ByteBuffer)buf, (int)0, (float)fontSize, (float[])ascent, (float[])descent, (float[])lineGap);
            this.lineSpacing = (int)(ascent[0] - descent[0] + lineGap[0]);
            this.descent = (int)Math.floor(descent[0]);
            this.textureId = GL32C.glGenTextures();
            GlState.bindTexture2D(this.textureId);
            GlDebug.labelTexture(this.textureId, "font texture " + String.valueOf(resource));
            try (STBTTPackedchar.Buffer packedchars = STBTTPackedchar.malloc((int)95);){
                int texwidth = 256;
                int texheight = 128;
                try (STBTTPackRange.Buffer packRanges = STBTTPackRange.malloc((int)1);){
                    ByteBuffer bitmap = BufferUtils.createByteBuffer((int)(texwidth * texheight));
                    try (STBTTPackRange packRange = STBTTPackRange.malloc();){
                        packRanges.put((Struct)packRange.set((float)fontSize, 32, null, 95, packedchars, (byte)1, (byte)1));
                        packRanges.flip();
                    }
                    try (STBTTPackContext pc = STBTTPackContext.malloc();){
                        STBTruetype.stbtt_PackBegin((STBTTPackContext)pc, (ByteBuffer)bitmap, (int)texwidth, (int)texheight, (int)0, (int)1, (long)0L);
                        STBTruetype.stbtt_PackSetOversampling((STBTTPackContext)pc, (int)1, (int)1);
                        STBTruetype.stbtt_PackSetSkipMissingCodepoints((STBTTPackContext)pc, (boolean)true);
                        STBTruetype.stbtt_PackFontRanges((STBTTPackContext)pc, (ByteBuffer)buf, (int)0, (STBTTPackRange.Buffer)packRanges);
                        STBTruetype.stbtt_PackEnd((STBTTPackContext)pc);
                        GL32C.glTexImage2D((int)3553, (int)0, (int)6403, (int)texwidth, (int)texheight, (int)0, (int)6403, (int)5121, (ByteBuffer)bitmap);
                        GL32C.glTexParameteri((int)3553, (int)10242, (int)33071);
                        GL32C.glTexParameteri((int)3553, (int)10243, (int)33071);
                        GL32C.glTexParameteri((int)3553, (int)10240, (int)9728);
                        GL32C.glTexParameteri((int)3553, (int)10241, (int)9728);
                    }
                }
                try (STBTTAlignedQuad q = STBTTAlignedQuad.malloc();){
                    float[] x = new float[1];
                    float[] y = new float[1];
                    Glyph[] glyphs = new Glyph[95];
                    for (int i = 0; i < 95; ++i) {
                        x[0] = 0.0f;
                        y[0] = fontSize;
                        STBTruetype.stbtt_GetPackedQuad((STBTTPackedchar.Buffer)packedchars, (int)texwidth, (int)texheight, (int)i, (float[])x, (float[])y, (STBTTAlignedQuad)q, (boolean)true);
                        glyphs[i] = new Glyph((char)(i + 32), (int)(x[0] - 0.0f), new int[]{(int)q.x0(), (int)q.y0(), (int)q.x1(), (int)q.y1()}, new float[]{q.s0(), q.t0(), q.s1(), q.t1()});
                    }
                    this.glyphGetter = codepoint -> {
                        if (codepoint < 32 || codepoint - 32 > 95) {
                            return null;
                        }
                        return glyphs[codepoint - 32];
                    };
                }
            }
        }
    }

    @Nullable
    private Glyph getGlyph(int codepoint) {
        return this.glyphGetter.apply(codepoint);
    }

    private Glyph getSpaceGlyph() {
        return Objects.requireNonNull(this.getGlyph(32));
    }

    public int lineSpacing() {
        return this.lineSpacing;
    }

    int textureId() {
        return this.textureId;
    }

    public int descent() {
        return this.descent;
    }

    public int stringWidth(String text) {
        return this.stringWidth(text, 0, text.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public int stringWidth(String text, int start, int end) {
        int len = 0;
        int i = start;
        while (i < end) {
            int c = text.codePointAt(i);
            len += (switch (c) {
                case 9, 10 -> 0;
                case 32 -> this.getSpaceGlyph().charwidth();
                default -> {
                    Glyph glyph = this.getGlyph(c);
                    if (glyph != null) {
                        yield glyph.charwidth();
                    }
                    yield 0;
                }
            });
            ++i;
        }
        return len;
    }

    public SimpleBufferBuilder generateVerticesForTexts(float x, float y, SimpleBufferBuilder textBB, Iterable<DisplayText> texts) {
        Pos pos = new Pos(x, y, x);
        for (DisplayText text : texts) {
            pos = text.generateStringArray(this, pos, textBB);
        }
        return textBB;
    }

    public record Glyph(char c, int charwidth, int[] pos, float[] uv) {
        Pos loadQuad(Pos pos, int colour, SimpleBufferBuilder bb) {
            float x0 = pos.x() + (float)this.pos()[0];
            float y0 = pos.y() + (float)this.pos()[1];
            float x1 = pos.x() + (float)this.pos()[2];
            float y1 = pos.y() + (float)this.pos()[3];
            bb.pos(x0, y0).tex(this.uv()[0], this.uv()[1]).colour(colour).endVertex();
            bb.pos(x1, y0).tex(this.uv()[2], this.uv()[1]).colour(colour).endVertex();
            bb.pos(x0, y1).tex(this.uv()[0], this.uv()[3]).colour(colour).endVertex();
            bb.pos(x1, y1).tex(this.uv()[2], this.uv()[3]).colour(colour).endVertex();
            return new Pos(pos.x() + (float)this.charwidth(), pos.y(), pos.minx());
        }
    }

    private record Pos(float x, float y, float minx) {
    }

    public record DisplayText(String string, int colour) {
        Pos generateStringArray(SimpleFont font, Pos pos, SimpleBufferBuilder bb) {
            for (int i = 0; i < this.string.length(); ++i) {
                int codepoint = this.string.codePointAt(i);
                pos = switch (codepoint) {
                    case 10 -> new Pos(pos.minx(), pos.y() + (float)font.lineSpacing(), pos.minx());
                    case 9 -> new Pos(pos.x() + (float)(font.getSpaceGlyph().charwidth() * 4), pos.y(), pos.minx());
                    case 32 -> new Pos(pos.x() + (float)font.getSpaceGlyph().charwidth(), pos.y(), pos.minx());
                    default -> {
                        Glyph glyph = font.getGlyph(codepoint);
                        if (glyph != null) {
                            pos = glyph.loadQuad(pos, this.colour(), bb);
                        }
                        yield pos;
                    }
                };
            }
            return pos;
        }

        public List<DisplayText> splitAt(int pos, boolean offsetSecond) {
            DisplayText partOne = new DisplayText(this.string.substring(0, pos), this.colour);
            DisplayText partTwo = new DisplayText(this.string.substring(pos + (offsetSecond ? 1 : 0)), this.colour);
            return List.of(partOne, partTwo);
        }
    }
}

