/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import org.jetbrains.annotations.Nullable;

final class FormatHelper {
    static List<List<SimpleFont.DisplayText>> formatText(String text, SimpleFont font, int defaultColor, int maxWidth) {
        ArrayList<List<SimpleFont.DisplayText>> lines = new ArrayList<List<SimpleFont.DisplayText>>();
        ArrayList<SimpleFont.DisplayText> parts = new ArrayList<SimpleFont.DisplayText>();
        int lastIndex = 0;
        int lastColor = defaultColor;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                parts.add(FormatHelper.part(text, lastIndex, i, lastColor));
                lastIndex = i + 2;
                lastColor = FormatHelper.getColor(text.charAt(i + 1), lastColor, defaultColor);
                continue;
            }
            if (c != '\n') continue;
            parts.add(FormatHelper.part(text, lastIndex, i, lastColor));
            lines.add(parts);
            parts = new ArrayList();
            lastIndex = i + 1;
        }
        if (lastIndex < text.length() - 1) {
            parts.add(FormatHelper.part(text, lastIndex, text.length(), lastColor));
        }
        if (!parts.isEmpty()) {
            lines.add(parts);
        }
        if (maxWidth > -1) {
            FormatHelper.wrapLines(lines, font, maxWidth);
        }
        return lines;
    }

    private static SimpleFont.DisplayText part(String text, int start, int end, int color) {
        return new SimpleFont.DisplayText(text.substring(start, end), color);
    }

    private static int getColor(char code, int lastColor, int defaultColor) {
        return switch (code) {
            case '0' -> -16777216;
            case '1' -> -16777046;
            case '2' -> -16733696;
            case '3' -> -16733526;
            case '4' -> -5636096;
            case '5' -> -5635926;
            case '6' -> -22016;
            case '7' -> -5592406;
            case '8' -> -11184811;
            case '9' -> -11184641;
            case 'a' -> -11141291;
            case 'b' -> -11141121;
            case 'c' -> -43691;
            case 'd' -> -43521;
            case 'e' -> -171;
            case 'f' -> -1;
            case 'r' -> defaultColor;
            default -> lastColor;
        };
    }

    private static void wrapLines(List<List<SimpleFont.DisplayText>> lines, SimpleFont font, int maxWidth) {
        block0: for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            List<SimpleFont.DisplayText> parts = lines.get(lineIdx);
            int lineWidth = 0;
            int[] widthsBeforePart = new int[parts.size() + 1];
            for (int partIdx = 0; partIdx < parts.size(); ++partIdx) {
                SimpleFont.DisplayText part = parts.get(partIdx);
                widthsBeforePart[partIdx] = lineWidth;
                if ((lineWidth += font.stringWidth(part.string())) < maxWidth) continue;
                SplitPos pos = FormatHelper.findSplitPos(parts, font, partIdx, widthsBeforePart, maxWidth);
                if (pos == null) continue block0;
                ArrayList<SimpleFont.DisplayText> newPartsOne = new ArrayList<SimpleFont.DisplayText>();
                ArrayList<SimpleFont.DisplayText> newPartsTwo = new ArrayList<SimpleFont.DisplayText>();
                for (int copyPartIdx = 0; copyPartIdx < parts.size(); ++copyPartIdx) {
                    if (copyPartIdx < pos.partIdx) {
                        newPartsOne.add(parts.get(copyPartIdx));
                        continue;
                    }
                    if (copyPartIdx == pos.partIdx) {
                        List<SimpleFont.DisplayText> splitParts = parts.get(copyPartIdx).splitAt(pos.charIdx, pos.onSpace);
                        newPartsOne.add(splitParts.getFirst());
                        newPartsTwo.add(splitParts.getLast());
                        continue;
                    }
                    newPartsTwo.add(parts.get(copyPartIdx));
                }
                lines.set(lineIdx, newPartsOne);
                lines.add(lineIdx + 1, newPartsTwo);
                continue block0;
            }
        }
    }

    @Nullable
    private static SplitPos findSplitPos(List<SimpleFont.DisplayText> parts, SimpleFont font, int startPart, int[] widthsBeforePart, int maxWidth) {
        int charIdx;
        String text;
        int partIdx;
        for (partIdx = startPart; partIdx >= 0; --partIdx) {
            text = parts.get(partIdx).string();
            for (charIdx = text.length() - 1; charIdx >= 0; --charIdx) {
                if (text.charAt(charIdx) != ' ' || widthsBeforePart[partIdx] + font.stringWidth(text, 0, charIdx) > maxWidth) continue;
                return new SplitPos(partIdx, charIdx, true);
            }
        }
        for (partIdx = startPart; partIdx >= 0; --partIdx) {
            text = parts.get(partIdx).string();
            for (charIdx = text.length() - 1; charIdx >= 0; --charIdx) {
                if (widthsBeforePart[partIdx] + font.stringWidth(text, 0, charIdx + 1) > maxWidth) continue;
                return new SplitPos(partIdx, charIdx, false);
            }
        }
        return null;
    }

    private FormatHelper() {
    }

    private record SplitPos(int partIdx, int charIdx, boolean onSpace) {
    }
}

