/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.neoforged.fml.earlydisplay.render.GlDebug;
import net.neoforged.fml.earlydisplay.render.GlState;
import net.neoforged.fml.earlydisplay.render.SimpleFont;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11C;

final class FontLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] FONT_PATHS = new String[]{"minecraft/font/unifont.zip", "minecraft/font/unifont_pua.zip", "minecraft/font/unifont_jp.zip"};
    private static final int GLYPH_HEIGHT = 16;

    @Nullable
    static SimpleFont loadVanillaFont(@Nullable String assetsDir, @Nullable String assetIndex) {
        if (assetsDir == null || assetIndex == null) {
            return null;
        }
        Path assets = Path.of(assetsDir, new String[0]);
        Path index = assets.resolve("indexes").resolve(assetIndex + ".json");
        if (!Files.isRegularFile(index, new LinkOption[0])) {
            return null;
        }
        ArrayList<Path> fontZipPaths = new ArrayList<Path>(FONT_PATHS.length);
        try (BufferedReader reader = new BufferedReader(Files.newBufferedReader(index));){
            JsonObject objects = ((JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class)).getAsJsonObject("objects");
            for (String path : FONT_PATHS) {
                if (!objects.has(path)) continue;
                String hash = objects.getAsJsonObject(path).get("hash").getAsString();
                Path fontZip = assets.resolve("objects").resolve(hash.substring(0, 2)).resolve(hash);
                if (!Files.isRegularFile(fontZip, new LinkOption[0])) continue;
                fontZipPaths.add(fontZip);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to load asset index file", e);
            return null;
        }
        if (fontZipPaths.isEmpty()) {
            return null;
        }
        ArrayList<ProtoGlyph> glyphs = new ArrayList<ProtoGlyph>();
        for (Path zipPath : fontZipPaths) {
            try (ZipInputStream stream = new ZipInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry;
                ArrayList fileGlyphs = new ArrayList();
                while ((entry = stream.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (!name.endsWith(".hex")) continue;
                    FontLoader.parseHexFile(stream, fileGlyphs::add);
                }
                glyphs.addAll(fileGlyphs);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to load font ZIP", e);
            }
        }
        return glyphs.isEmpty() ? null : FontLoader.buildFont(glyphs);
    }

    private static void parseHexFile(InputStream stream, Consumer<ProtoGlyph> glyphOutput) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            int colon = line.indexOf(58);
            if (colon < 4 || colon > 6) {
                throw new IllegalStateException();
            }
            int codepoint = Integer.parseInt(line.substring(0, colon), 16);
            String bitmap = line.substring(colon + 1);
            int hexCount = bitmap.length();
            if (hexCount != 32 && hexCount != 64 && hexCount != 96 && hexCount != 128) {
                throw new IllegalStateException();
            }
            int hexPerLine = hexCount / 16;
            int width = hexPerLine * 4;
            int[] lines = new int[16];
            for (int i = 0; i < hexCount; ++i) {
                int lineIdx = i / hexPerLine;
                int offset = (hexPerLine - 1 - i % hexPerLine) * 4;
                int digit = FontLoader.parseHexDigit(bitmap.charAt(i));
                int n = lineIdx;
                lines[n] = lines[n] | digit << offset;
            }
            glyphOutput.accept(new ProtoGlyph(codepoint, width, lines));
        }
    }

    private static int parseHexDigit(char digit) {
        return switch (digit) {
            case '0' -> 0;
            case '1' -> 1;
            case '2' -> 2;
            case '3' -> 3;
            case '4' -> 4;
            case '5' -> 5;
            case '6' -> 6;
            case '7' -> 7;
            case '8' -> 8;
            case '9' -> 9;
            case 'A', 'a' -> 10;
            case 'B', 'b' -> 11;
            case 'C', 'c' -> 12;
            case 'D', 'd' -> 13;
            case 'E', 'e' -> 14;
            case 'F', 'f' -> 15;
            default -> throw new IllegalArgumentException("Not a hex digit: " + digit);
        };
    }

    @Nullable
    private static SimpleFont buildFont(List<ProtoGlyph> glyphs) {
        int textureId = GL11C.glGenTextures();
        GlState.bindTexture2D(textureId);
        GlDebug.labelTexture(textureId, "unifont texture");
        int totalPixels = glyphs.stream().mapToInt(g -> g.width * 16).sum();
        boolean incWidth = true;
        int texWidth = 512;
        int texHeight = 512;
        while (texWidth * texHeight < totalPixels) {
            if (incWidth) {
                texWidth <<= 1;
            } else {
                texHeight <<= 1;
            }
            incWidth = !incWidth;
        }
        int maxTexSize = GL11C.glGetInteger((int)3379);
        if (texWidth > maxTexSize || texHeight > maxTexSize) {
            return null;
        }
        int x = 0;
        int y = 0;
        HashMap<Integer, SimpleFont.Glyph> glyphMap = new HashMap<Integer, SimpleFont.Glyph>();
        ByteBuffer bitmap = BufferUtils.createByteBuffer((int)(texWidth * texHeight));
        for (ProtoGlyph glyph : glyphs) {
            char c = Character.toChars(glyph.codepoint)[0];
            int[] pos = new int[]{0, 4, glyph.width, 20};
            float[] uv = new float[]{(float)x / (float)texWidth, (float)y / (float)texHeight, (float)(x + glyph.width) / (float)texWidth, (float)(y + 16) / (float)texHeight};
            glyphMap.put(glyph.codepoint, new SimpleFont.Glyph(c, glyph.width, pos, uv));
            int[] lines = glyph.lines;
            for (int i = 0; i < lines.length; ++i) {
                int line = lines[i];
                int baseIdx = (y + i) * texWidth + x;
                for (int lx = 0; lx < glyph.width; ++lx) {
                    int idx = baseIdx + lx;
                    int value = (line >> glyph.width - 1 - lx & 1) * 255;
                    bitmap.put(idx, (byte)value);
                }
            }
            if ((x += glyph.width) < texWidth) continue;
            x = 0;
            y += 16;
        }
        GL11C.glTexImage2D((int)3553, (int)0, (int)6403, (int)texWidth, (int)texHeight, (int)0, (int)6403, (int)5121, (ByteBuffer)bitmap);
        GL11C.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11C.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11C.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11C.glTexParameteri((int)3553, (int)10241, (int)9728);
        if (!glyphMap.containsKey(32)) {
            return null;
        }
        return new SimpleFont(24, 16, textureId, glyphMap::get);
    }

    private FontLoader() {
    }

    private record ProtoGlyph(int codepoint, int width, int[] lines) {
    }
}

