/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.error;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.earlydisplay.error.ErrorDisplayWindow;
import net.neoforged.fml.earlydisplay.render.GlState;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Callback;

public final class ErrorDisplay {
    private static final boolean THROW_ON_EXIT = Boolean.getBoolean("fml.loadingErrorThrowOnExit");
    private static final long MINFRAMETIME = TimeUnit.MILLISECONDS.toNanos(10L);

    public static void fatal(long windowHandle, @Nullable String assetsDir, @Nullable String assetIndex, List<ModLoadingIssue> errors, @Nullable Path modsFolder, @Nullable Path logFile, @Nullable Path crashReportFile) {
        ErrorDisplay.clearCallbacks(windowHandle);
        ErrorDisplayWindow window = new ErrorDisplayWindow(windowHandle, assetsDir, assetIndex, errors, modsFolder, logFile, crashReportFile);
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowCloseCallback((long)window.windowHandle, window::handleClose));
        ErrorDisplay.discard((Callback)GLFW.glfwSetCursorPosCallback((long)window.windowHandle, window::handleCursorPos));
        ErrorDisplay.discard((Callback)GLFW.glfwSetScrollCallback((long)window.windowHandle, window::handleMouseScroll));
        ErrorDisplay.discard((Callback)GLFW.glfwSetMouseButtonCallback((long)window.windowHandle, window::handleMouseButton));
        ErrorDisplay.discard((Callback)GLFW.glfwSetKeyCallback((long)window.windowHandle, window::handleKey));
        long nextFrameTime = 0L;
        GlState.readFromOpenGL();
        while (!window.isClosed()) {
            long nanoTime = System.nanoTime();
            long timeToNextFrame = nextFrameTime - nanoTime;
            if (timeToNextFrame <= 0L) {
                window.render();
                nextFrameTime = nanoTime + MINFRAMETIME;
                GLFW.glfwPollEvents();
                continue;
            }
            GLFW.glfwWaitEventsTimeout((double)((double)timeToNextFrame / (double)TimeUnit.SECONDS.toNanos(1L)));
        }
        window.teardown();
        if (THROW_ON_EXIT) {
            throw new FatalLoadingError();
        }
        System.exit(1);
    }

    private static void clearCallbacks(long windowHandle) {
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowPosCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowSizeCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowCloseCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowRefreshCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowFocusCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowIconifyCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowMaximizeCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetFramebufferSizeCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetWindowContentScaleCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetKeyCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetCharCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetCharModsCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetMouseButtonCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetCursorPosCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetCursorEnterCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetScrollCallback((long)windowHandle, null));
        ErrorDisplay.discard((Callback)GLFW.glfwSetDropCallback((long)windowHandle, null));
    }

    private static void discard(@Nullable Callback callback) {
        if (callback != null) {
            callback.close();
        }
    }

    private ErrorDisplay() {
    }

    public static class FatalLoadingError
    extends RuntimeException {
    }
}

