/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.theme;

import java.util.Map;
import net.neoforged.fml.earlydisplay.theme.AnimationMetadata;
import net.neoforged.fml.earlydisplay.theme.TextureScaling;
import net.neoforged.fml.earlydisplay.theme.ThemeColorScheme;
import net.neoforged.fml.earlydisplay.theme.ThemeLoadingScreen;
import net.neoforged.fml.earlydisplay.theme.ThemeMojangLogoElement;
import net.neoforged.fml.earlydisplay.theme.ThemeResource;
import net.neoforged.fml.earlydisplay.theme.ThemeShader;
import net.neoforged.fml.earlydisplay.theme.ThemeSprites;
import net.neoforged.fml.earlydisplay.theme.ThemeTexture;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeImageElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeLabelElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemePerformanceElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeProgressBarsElement;
import net.neoforged.fml.earlydisplay.theme.elements.ThemeStartupLogElement;
import net.neoforged.fml.earlydisplay.util.StyleLength;

public record Theme(ThemeResource windowIcon, Map<String, ThemeResource> fonts, Map<String, ThemeShader> shaders, ThemeColorScheme colorScheme, ThemeSprites sprites, ThemeLoadingScreen loadingScreen) {
    public static final String FONT_DEFAULT = "default";
    public static final String SHADER_GUI = "gui";
    public static final String SHADER_FONT = "font";
    public static final String SHADER_COLOR = "color";

    public static Theme createDefaultTheme() {
        ThemeSprites sprites = new ThemeSprites(new ThemeTexture(new ThemeResource("progress_bar_bg.png"), new TextureScaling.NineSlice(40, 20, 2, 2, 2, 2, true, true, false)), new ThemeTexture(new ThemeResource("progress_bar_fg.png"), new TextureScaling.NineSlice(40, 20, 4, 4, 4, 4, true, true, false)), new ThemeTexture(new ThemeResource("progress_bar_fg.png"), new TextureScaling.NineSlice(40, 20, 4, 4, 4, 4, true, true, false)), false);
        ThemeStartupLogElement startupLog = new ThemeStartupLogElement();
        startupLog.setLeft(StyleLength.ofPoints(10.0f));
        startupLog.setBottom(StyleLength.ofPoints(10.0f));
        ThemeImageElement fox = new ThemeImageElement();
        fox.setTexture(new ThemeTexture(new ThemeResource("fox_running.png"), new TextureScaling.Stretch(151, 128, false), new AnimationMetadata(28)));
        fox.setRight(StyleLength.ofPoints(10.0f));
        fox.setBottom(StyleLength.ofREM(1.0f));
        ThemeLabelElement forgeVersion = new ThemeLabelElement();
        forgeVersion.setText("${version}");
        forgeVersion.setBottom(StyleLength.ofPoints(10.0f));
        forgeVersion.setRight(StyleLength.ofPoints(10.0f));
        ThemeProgressBarsElement progressBars = new ThemeProgressBarsElement();
        progressBars.setLabelGap(4);
        progressBars.setBarGap(5);
        progressBars.setLeft(StyleLength.ofPoints(220.0f));
        progressBars.setRight(StyleLength.ofPoints(220.0f));
        progressBars.setTop(StyleLength.ofPoints(250.0f));
        progressBars.setMaintainAspectRatio(false);
        ThemePerformanceElement performance = new ThemePerformanceElement();
        performance.setLeft(StyleLength.ofPoints(220.0f));
        performance.setRight(StyleLength.ofPoints(220.0f));
        performance.setTop(StyleLength.ofPoints(10.0f));
        ThemeMojangLogoElement mojangLogo = new ThemeMojangLogoElement();
        mojangLogo.setCenterHorizontally(true);
        mojangLogo.setTop(StyleLength.ofPoints(96.0f));
        return new Theme(new ThemeResource("neoforged_icon.png"), Map.of(FONT_DEFAULT, new ThemeResource("Monocraft.ttf")), Map.of(SHADER_GUI, ThemeShader.DEFAULT_GUI, SHADER_FONT, ThemeShader.DEFAULT_FONT, SHADER_COLOR, ThemeShader.DEFAULT_COLOR), ThemeColorScheme.DEFAULT, sprites, new ThemeLoadingScreen(performance, progressBars, startupLog, mojangLogo, Map.of("fox", fox, "version", forgeVersion)));
    }
}

