/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay.theme;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Objects;
import net.neoforged.fml.earlydisplay.theme.ImageLoader;
import net.neoforged.fml.earlydisplay.theme.NativeBuffer;
import net.neoforged.fml.earlydisplay.theme.UncompressedImage;
import org.jetbrains.annotations.Nullable;

public record ThemeResource(String path) {
    public NativeBuffer toNativeBuffer(@Nullable Path externalThemeDirectory) throws IOException {
        if (externalThemeDirectory != null) {
            try {
                return NativeBuffer.loadFromPath(externalThemeDirectory.resolve(this.path));
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return NativeBuffer.loadFromClasspath("net/neoforged/fml/earlydisplay/theme/" + this.path, null);
    }

    public UncompressedImage loadAsImage(@Nullable Path externalThemeDirectory) {
        return ImageLoader.loadImage(this, externalThemeDirectory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public UncompressedImage tryLoadAsImage(@Nullable Path externalThemeDirectory) {
        ImageLoader.Result result = ImageLoader.tryLoadImage(this, externalThemeDirectory);
        Objects.requireNonNull(result);
        ImageLoader.Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImageLoader.Result.Error.class, ImageLoader.Result.Success.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ImageLoader.Result.Error error = (ImageLoader.Result.Error)result2;
                return null;
            }
            case 1: 
        }
        ImageLoader.Result.Success success = (ImageLoader.Result.Success)result2;
        try {
            UncompressedImage uncompressedImage2;
            UncompressedImage image;
            UncompressedImage uncompressedImage = image = (uncompressedImage2 = success.image());
            return uncompressedImage;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

