/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.bus;

import net.neoforged.bus.EventAccessTransformer;
import net.neoforged.bus.EventSubclassTransformer;
import net.neoforged.bus.IEventBusEngine;
import net.neoforged.bus.LogMarkers;
import net.neoforged.bus.ModLauncherFactory;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public final class EventBusEngine
implements IEventBusEngine {
    private final EventSubclassTransformer eventTransformer;
    private final EventAccessTransformer accessTransformer;
    final String EVENT_CLASS = "net.neoforged.bus.api.Event";

    public EventBusEngine() {
        LogManager.getLogger().debug(LogMarkers.EVENTBUS, "Loading EventBus transformers");
        this.eventTransformer = new EventSubclassTransformer();
        this.accessTransformer = new EventAccessTransformer();
    }

    @Override
    public int processClass(ClassNode classNode, Type classType) {
        if (ModLauncherFactory.hasPendingWrapperClass(classType.getClassName())) {
            ModLauncherFactory.processWrapperClass(classType.getClassName(), classNode);
            LogManager.getLogger().debug(LogMarkers.EVENTBUS, "Built transformed event wrapper class {}", (Object)classType.getClassName());
            return 2;
        }
        int evtXformFlags = this.eventTransformer.transform(classNode, classType).isPresent() ? 2 : 0;
        int axXformFlags = this.accessTransformer.transform(classNode, classType) ? 256 : 0;
        return evtXformFlags | axXformFlags;
    }

    @Override
    public boolean handlesClass(Type classType) {
        String name = classType.getClassName();
        return !name.startsWith("net.minecraft.") && name.indexOf(46) != -1;
    }

    @Override
    public boolean findASMEventDispatcher(Type classType) {
        return ModLauncherFactory.hasPendingWrapperClass(classType.getClassName());
    }
}

