/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.EventListenerHelper;

public class Event {
    private boolean isCanceled = false;
    private Result result = Result.DEFAULT;

    public boolean isCancelable() {
        return EventListenerHelper.isCancelable(this.getClass());
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new UnsupportedOperationException("Attempted to call Event#setCanceled() on a non-cancelable event of type: " + this.getClass().getCanonicalName());
        }
        this.isCanceled = cancel;
    }

    public boolean hasResult() {
        return EventListenerHelper.hasResult(this.getClass());
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result value) {
        this.result = value;
    }

    public ListenerList getListenerList() {
        return EventListenerHelper.getListenerListInternal(this.getClass(), true);
    }

    public static enum Result {
        DENY,
        DEFAULT,
        ALLOW;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface HasResult {
    }
}

