/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventListener;
import org.jetbrains.annotations.Nullable;

public class ListenerList {
    private static List<ListenerList> allLists = new ArrayList<ListenerList>();
    private static int maxSize = 0;
    @Nullable
    private ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(@Nullable ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        allLists.add(inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void resize(int max) {
        if (max <= maxSize) return;
        Class<ListenerList> clazz = ListenerList.class;
        synchronized (ListenerList.class) {
            if (max <= maxSize) return;
            allLists.forEach(list -> list.resizeLists(max));
            maxSize = max;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private synchronized void resizeLists(int max) {
        int x;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        for (x = 0; x < this.lists.length; ++x) {
            newList[x] = this.lists[x];
        }
        while (x < max) {
            newList[x] = this.parent != null ? new ListenerListInst(this.parent.getInstance(x)) : new ListenerListInst();
            ++x;
        }
        this.lists = newList;
    }

    public static synchronized void clearBusID(int id) {
        for (ListenerList list : allLists) {
            list.lists[id].dispose();
        }
    }

    protected ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static synchronized void unregisterAll(int id, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id, listener);
        }
    }

    private class ListenerListInst {
        private boolean rebuild = true;
        private AtomicReference<IEventListener[]> listeners = new AtomicReference();
        private ArrayList<ArrayList<IEventListener>> priorities;
        private ListenerListInst parent;
        private List<ListenerListInst> children;
        private Semaphore writeLock = new Semaphore(1, true);

        private ListenerListInst() {
            int count = EventPriority.values().length;
            this.priorities = new ArrayList(count);
            for (int x = 0; x < count; ++x) {
                this.priorities.add(new ArrayList());
            }
        }

        public void dispose() {
            this.writeLock.acquireUninterruptibly();
            this.priorities.forEach((Consumer<ArrayList<IEventListener>>)((Consumer<ArrayList>)ArrayList::clear));
            this.priorities.clear();
            this.writeLock.release();
            this.parent = null;
            this.listeners = null;
            if (this.children != null) {
                this.children.clear();
            }
        }

        private ListenerListInst(ListenerListInst parent) {
            this();
            this.parent = parent;
            this.parent.addChild(this);
        }

        public ArrayList<IEventListener> getListeners(EventPriority priority) {
            this.writeLock.acquireUninterruptibly();
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>((Collection)this.priorities.get(priority.ordinal()));
            this.writeLock.release();
            if (this.parent != null) {
                ret.addAll(this.parent.getListeners(priority));
            }
            return ret;
        }

        public IEventListener[] getListeners() {
            if (this.shouldRebuild()) {
                this.buildCache();
            }
            return this.listeners.get();
        }

        protected boolean shouldRebuild() {
            return this.rebuild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forceRebuild() {
            this.rebuild = true;
            if (this.children != null) {
                List<ListenerListInst> list = this.children;
                synchronized (list) {
                    for (ListenerListInst child : this.children) {
                        child.forceRebuild();
                    }
                }
            }
        }

        private void addChild(ListenerListInst child) {
            if (this.children == null) {
                this.children = Collections.synchronizedList(new ArrayList(2));
            }
            this.children.add(child);
        }

        private void buildCache() {
            if (this.parent != null && this.parent.shouldRebuild()) {
                this.parent.buildCache();
            }
            ArrayList ret = new ArrayList();
            Arrays.stream(EventPriority.values()).forEach(value -> ret.addAll(this.getListeners((EventPriority)((Object)value))));
            this.listeners.set(ret.toArray(new IEventListener[0]));
            this.rebuild = false;
        }

        public void register(EventPriority priority, IEventListener listener) {
            this.writeLock.acquireUninterruptibly();
            this.priorities.get(priority.ordinal()).add(listener);
            this.writeLock.release();
            this.forceRebuild();
        }

        public void unregister(IEventListener listener) {
            this.writeLock.acquireUninterruptibly();
            this.priorities.stream().filter(list -> list.remove(listener)).forEach(list -> this.forceRebuild());
            this.writeLock.release();
        }
    }
}

