/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.bus;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.neoforged.bus.LockHelper;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class EventListenerFactory {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String HANDLER_DESC = Type.getInternalName(EventListener.class);
    private static final String HANDLER_FUNC_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Event.class)});
    private static final String INSTANCE_FUNC_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class), Type.getType(Event.class)});
    private static final MethodType STATIC_HANDLER = MethodType.methodType(Void.TYPE, Event.class);
    private static final MethodType INSTANCE_HANDLER = MethodType.methodType(Void.TYPE, Object.class, Event.class);
    private static final MethodType STATIC_CONSTRUCTOR = MethodType.methodType(Void.TYPE);
    private static final MethodType INSTANCE_CONSTRUCTOR = MethodType.methodType(Void.TYPE, Object.class);
    private static final ConstantDynamic METHOD_CONSTANT = new ConstantDynamic("_", MethodHandle.class.descriptorString(), new Handle(6, Type.getInternalName(MethodHandles.class), "classData", MethodType.methodType(Object.class, MethodHandles.Lookup.class, String.class, Class.class).descriptorString(), false), new Object[0]);
    private static final LockHelper<Method, MethodHandle> eventListenerFactories = LockHelper.withHashMap();

    EventListenerFactory() {
    }

    private static MethodHandle getEventListenerFactory(Method m) {
        return eventListenerFactories.computeIfAbsent(m, EventListenerFactory::createWrapper0);
    }

    private static MethodHandle createWrapper0(Method callback) {
        try {
            callback.setAccessible(true);
            MethodHandle handle = LOOKUP.unreflect(callback);
            boolean isStatic = Modifier.isStatic(callback.getModifiers());
            MethodHandle boxedHandle = handle.asType(isStatic ? STATIC_HANDLER : INSTANCE_HANDLER);
            byte[] classBytes = EventListenerFactory.makeClass(EventListenerFactory.class.getName() + "$" + callback.getName(), isStatic);
            MethodHandles.Lookup classLookup = LOOKUP.defineHiddenClassWithClassData(classBytes, boxedHandle, true, new MethodHandles.Lookup.ClassOption[0]);
            return classLookup.findConstructor(classLookup.lookupClass(), isStatic ? STATIC_CONSTRUCTOR : INSTANCE_CONSTRUCTOR);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create listener", e);
        }
    }

    protected static byte[] makeClass(String name, boolean isStatic) {
        ClassWriter cv = new ClassWriter(0);
        String desc = name.replace('.', '/');
        cv.visit(60, 17, desc, null, HANDLER_DESC, null);
        cv.visitSource(".dynamic", null);
        if (!isStatic) {
            cv.visitField(18, "instance", "Ljava/lang/Object;", null, null).visitEnd();
        }
        MethodVisitor mv = cv.visitMethod(1, "<init>", isStatic ? "()V" : "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, HANDLER_DESC, "<init>", "()V", false);
        if (!isStatic) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, desc, "instance", "Ljava/lang/Object;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cv.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)METHOD_CONSTANT);
        if (!isStatic) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, desc, "instance", "Ljava/lang/Object;");
        }
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", isStatic ? HANDLER_FUNC_DESC : INSTANCE_FUNC_DESC, false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        cv.visitEnd();
        return cv.toByteArray();
    }

    public static EventListener create(Method callback, Object target) {
        try {
            MethodHandle factory = EventListenerFactory.getEventListenerFactory(callback);
            if (Modifier.isStatic(callback.getModifiers())) {
                return factory.invoke();
            }
            return factory.invoke(target);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to create IEventListener", e);
        }
    }
}

