/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

import java.util.Objects;
import net.neoforged.accesstransformer.parser.TargetType;

public abstract class Target {
    private final String className;

    Target(String className) {
        this.className = className;
    }

    public String className() {
        return this.className;
    }

    public abstract boolean matches(String var1, TargetType var2, String var3);

    public static class WildcardFieldTarget
    extends Target {
        public WildcardFieldTarget(String className) {
            super(className);
        }

        public String toString() {
            return this.className() + " FIELDWILDCARD";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WildcardFieldTarget)) {
                return false;
            }
            WildcardFieldTarget that = (WildcardFieldTarget)o;
            return Objects.equals(this.className(), that.className());
        }

        public int hashCode() {
            return Objects.hash(this.className());
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.FIELD && this.className().equals(className);
        }
    }

    public static class WildcardMethodTarget
    extends Target {
        public WildcardMethodTarget(String className) {
            super(className);
        }

        public String toString() {
            return this.className() + " METHODWILDCARD";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WildcardMethodTarget)) {
                return false;
            }
            WildcardMethodTarget that = (WildcardMethodTarget)o;
            return Objects.equals(this.className(), that.className());
        }

        public int hashCode() {
            return Objects.hash(this.className());
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.METHOD && this.className().equals(className);
        }
    }

    public static class MethodTarget
    extends Target {
        private final String methodName;
        private final String methodDescriptor;

        public MethodTarget(String className, String methodName, String methodDescriptor) {
            super(className);
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        public String methodName() {
            return this.methodName;
        }

        public String methodDescriptor() {
            return this.methodDescriptor;
        }

        public String toString() {
            return this.className() + " METHOD " + this.methodName() + this.methodDescriptor();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodTarget)) {
                return false;
            }
            MethodTarget that = (MethodTarget)o;
            return Objects.equals(this.className(), that.className()) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodDescriptor, that.methodDescriptor);
        }

        public int hashCode() {
            return Objects.hash(this.className(), this.methodName, this.methodDescriptor);
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.METHOD && this.className().equals(className) && targetName.equals(this.methodName + this.methodDescriptor);
        }
    }

    public static class FieldTarget
    extends Target {
        private final String fieldName;

        public FieldTarget(String className, String fieldName) {
            super(className);
            this.fieldName = fieldName;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String toString() {
            return this.className() + " FIELD " + this.fieldName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldTarget)) {
                return false;
            }
            FieldTarget that = (FieldTarget)o;
            return Objects.equals(this.className(), that.className()) && Objects.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return Objects.hash(this.className(), this.fieldName);
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.FIELD && this.className().equals(className) && this.fieldName.equals(targetName);
        }
    }

    public static class InnerClassTarget
    extends Target {
        private final String innerName;

        public InnerClassTarget(String className, String innerName) {
            super(className);
            this.innerName = innerName;
        }

        public String innerName() {
            return this.innerName;
        }

        public String toString() {
            int idx = this.innerName().lastIndexOf(36);
            return this.className() + " INNERCLASS " + this.innerName().substring(idx + 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InnerClassTarget)) {
                return false;
            }
            InnerClassTarget that = (InnerClassTarget)o;
            return Objects.equals(this.className(), that.className()) && Objects.equals(this.innerName, that.innerName);
        }

        public int hashCode() {
            return Objects.hash(this.className(), this.innerName);
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.CLASS && this.innerName.equals(className);
        }
    }

    public static class ClassTarget
    extends Target {
        public ClassTarget(String className) {
            super(className);
        }

        public String toString() {
            return this.className() + " CLASS";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassTarget)) {
                return false;
            }
            ClassTarget that = (ClassTarget)o;
            return Objects.equals(this.className(), that.className());
        }

        public int hashCode() {
            return Objects.hash(this.className());
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.CLASS && this.className().equals(className);
        }
    }
}

