/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

import net.neoforged.accesstransformer.parser.TargetType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Target {
    public String className();

    public boolean matches(String var1, TargetType var2, String var3);

    public record WildcardFieldTarget(String className) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " FIELDWILDCARD";
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.FIELD && this.className.equals(className);
        }
    }

    public record WildcardMethodTarget(String className) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " METHODWILDCARD";
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.METHOD && this.className.equals(className);
        }
    }

    public record MethodTarget(String className, String methodName, String methodDescriptor) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " METHOD " + this.methodName() + this.methodDescriptor();
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.METHOD && this.className.equals(className) && targetName.equals(this.methodName + this.methodDescriptor);
        }
    }

    public record FieldTarget(String className, String fieldName) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " FIELD " + this.fieldName();
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.FIELD && this.className.equals(className) && this.fieldName.equals(targetName);
        }
    }

    public record InnerClassTarget(String className, String innerName) implements Target
    {
        @Override
        public String toString() {
            int idx = this.innerName().lastIndexOf(36);
            return this.className() + " INNERCLASS " + this.innerName().substring(idx + 1);
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.CLASS && this.innerName.equals(className);
        }
    }

    public record ClassTarget(String className) implements Target
    {
        @Override
        public String toString() {
            return this.className() + " CLASS";
        }

        @Override
        public boolean matches(String className, TargetType type, String targetName) {
            return type == TargetType.CLASS && this.className.equals(className);
        }
    }
}

