/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Set;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.TargetType;
import net.neoforged.accesstransformer.parser.Transformation;
import org.objectweb.asm.tree.MethodNode;

public class MethodAccessTransformer
extends AccessTransformer<MethodNode> {
    private final String targetName;

    public MethodAccessTransformer(Target.MethodTarget target, Transformation transformation) {
        super(target, transformation);
        this.targetName = target.methodName() + target.methodDescriptor();
    }

    @Override
    public TargetType getType() {
        return TargetType.METHOD;
    }

    @Override
    public String targetName() {
        return this.targetName;
    }

    @Override
    protected void apply(MethodNode node, Set<String> privateChanged) {
        boolean wasPrivate = (node.access & 2) == 2;
        node.access = MethodAccessTransformer.mergeWith(node.access, this.getTransformation().modifier(), this.getTransformation().finalState());
        if (wasPrivate && !"<init>".equals(node.name) && (node.access & 2) != 2) {
            privateChanged.add(node.name + node.desc);
        }
    }
}

