/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import net.neoforged.accesstransformer.ClassAccessTransformer;
import net.neoforged.accesstransformer.FieldAccessTransformer;
import net.neoforged.accesstransformer.InnerClassAccessTransformer;
import net.neoforged.accesstransformer.MethodAccessTransformer;
import net.neoforged.accesstransformer.WildcardAccessTransformer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.TargetType;
import net.neoforged.accesstransformer.parser.Transformation;

public abstract class AccessTransformer<T> {
    private final Transformation transformation;
    private final Target target;
    private static final Transformation.Modifier[] lookup = new Transformation.Modifier[4];

    public AccessTransformer(Target target, Transformation transformation) {
        this.transformation = transformation;
        this.target = target;
    }

    public static AccessTransformer<?> of(Target target, Transformation transformation) {
        if (target instanceof Target.MethodTarget) {
            return new MethodAccessTransformer((Target.MethodTarget)target, transformation);
        }
        if (target instanceof Target.FieldTarget) {
            return new FieldAccessTransformer((Target.FieldTarget)target, transformation);
        }
        if (target instanceof Target.ClassTarget) {
            return new ClassAccessTransformer((Target.ClassTarget)target, transformation);
        }
        if (target instanceof Target.InnerClassTarget) {
            return new InnerClassAccessTransformer((Target.InnerClassTarget)target, transformation);
        }
        if (target instanceof Target.WildcardFieldTarget) {
            return new WildcardAccessTransformer((Target.WildcardFieldTarget)target, transformation);
        }
        if (target instanceof Target.WildcardMethodTarget) {
            return new WildcardAccessTransformer((Target.WildcardMethodTarget)target, transformation);
        }
        throw new IllegalArgumentException("Unknown target type: " + target.getClass());
    }

    public TargetType getType() {
        return TargetType.CLASS;
    }

    public String getClassName() {
        return this.target.className();
    }

    public final Transformation getTransformation() {
        return this.transformation;
    }

    public String toString() {
        return this.target + " " + this.transformation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessTransformer)) {
            return false;
        }
        AccessTransformer at2 = (AccessTransformer)obj;
        return Objects.equals(this.target, at2.target) && Objects.equals(this.transformation, at2.transformation);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.transformation);
    }

    private static int accFlag(Transformation.Modifier modifier) {
        switch (modifier) {
            case PUBLIC: {
                return 1;
            }
            case PROTECTED: {
                return 4;
            }
            case PRIVATE: {
                return 2;
            }
            case DEFAULT: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unknown modifier: " + (Object)((Object)modifier));
    }

    private static int firstBit(int flags) {
        return flags == 0 ? 0 : AccessTransformer.firstBit(flags >>> 1) + 1;
    }

    private static int mergeWith(int access, Transformation.Modifier modifier) {
        Transformation.Modifier floor = lookup[AccessTransformer.firstBit(access & 7)];
        return access & 0xFFFFFFF8 | AccessTransformer.accFlag(Transformation.Modifier.values()[Math.min(floor.ordinal(), modifier.ordinal())]);
    }

    private static int mergeWith(int access, Transformation.FinalState finalState) {
        switch (finalState) {
            case LEAVE: {
                return access;
            }
            case CONFLICT: {
                return access;
            }
            case MAKEFINAL: {
                return access | 0x10;
            }
            case REMOVEFINAL: {
                return access & 0xFFFFFFEF;
            }
        }
        throw new IllegalArgumentException("Unknown final state: " + (Object)((Object)finalState));
    }

    public static int mergeWith(int access, Transformation.Modifier modifier, Transformation.FinalState finalState) {
        return AccessTransformer.mergeWith(AccessTransformer.mergeWith(access, modifier), finalState);
    }

    public abstract String targetName();

    protected abstract void apply(T var1, Set<String> var2);

    public static <T> void applyTransform(AccessTransformer<?> accessTransformer, T node, Set<String> privateChanged) {
        accessTransformer.apply(node, privateChanged);
    }

    static {
        Arrays.stream(Transformation.Modifier.values()).forEach(m -> {
            AccessTransformer.lookup[AccessTransformer.firstBit((int)AccessTransformer.accFlag((Transformation.Modifier)m))] = m;
        });
    }
}

