/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.neoforged.accesstransformer.Target;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class AccessTransformer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker AXFORM_MARKER = MarkerManager.getMarker("AXFORM");
    private final Target<?> memberTarget;
    private final Modifier targetAccess;
    private final FinalState targetFinalState;
    private final List<String> origins = new ArrayList<String>(1);

    public AccessTransformer(Target<?> target, Modifier modifier, FinalState finalState, String origin, int lineNumber) {
        this.memberTarget = target;
        this.targetAccess = modifier;
        this.targetFinalState = finalState;
        this.origins.add(origin + ":" + lineNumber);
    }

    public <T> Target<T> getTarget() {
        return this.memberTarget;
    }

    public AccessTransformer mergeStates(AccessTransformer at2, String resourceName) {
        Modifier newModifier = Modifier.values()[Math.min(this.targetAccess.ordinal(), at2.targetAccess.ordinal())];
        FinalState newFinalState = FinalState.values()[this.targetFinalState.ordinal() | at2.targetFinalState.ordinal()];
        AccessTransformer accessTransformer = new AccessTransformer(this.memberTarget, newModifier, newFinalState, resourceName + ":merge", 0);
        accessTransformer.origins.addAll(this.origins);
        accessTransformer.origins.addAll(at2.origins);
        return accessTransformer;
    }

    public boolean isValid() {
        return this.targetFinalState != FinalState.CONFLICT;
    }

    public List<String> getOrigins() {
        return this.origins;
    }

    public <T> void applyModifier(T node, Class<T> type, Set<String> privateChanged) {
        LOGGER.debug(AXFORM_MARKER, "Transforming {} to access {} and {}", (Object)this.getTarget(), (Object)this.targetAccess, (Object)this.targetFinalState);
        this.getTarget().apply(node, this.targetAccess, this.targetFinalState, privateChanged);
    }

    public String toString() {
        return Objects.toString(this.memberTarget) + " " + Objects.toString((Object)this.targetAccess) + " " + Objects.toString((Object)this.targetFinalState) + " " + Objects.toString(this.origins.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public static enum Modifier {
        PUBLIC(1),
        PROTECTED(4),
        DEFAULT(0),
        PRIVATE(2);

        private static final Modifier[] lookup;
        private final int accFlag;

        private Modifier(int accFlag) {
            this.accFlag = accFlag;
        }

        private static int firstBit(int flags) {
            return flags == 0 ? 0 : Modifier.firstBit(flags >>> 1) + 1;
        }

        public int mergeWith(int access) {
            Modifier floor = lookup[Modifier.firstBit(access & 7)];
            return access & 0xFFFFFFF8 | Modifier.values()[Math.min((int)floor.ordinal(), (int)this.ordinal())].accFlag;
        }

        static {
            lookup = new Modifier[4];
            Arrays.stream(Modifier.values()).forEach(m -> {
                Modifier.lookup[Modifier.firstBit((int)m.accFlag)] = m;
            });
        }
    }

    public static enum FinalState {
        LEAVE(i -> i),
        MAKEFINAL(i -> i | 0x10),
        REMOVEFINAL(i -> i & 0xFFFFFFEF),
        CONFLICT(i -> i);

        private IntFunction<Integer> function;

        private FinalState(IntFunction<Integer> function) {
            this.function = function;
        }

        public int mergeWith(int access) {
            return this.function.apply(access);
        }
    }
}

