/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Set;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.TargetType;
import net.neoforged.accesstransformer.parser.Transformation;
import org.objectweb.asm.tree.FieldNode;

public class FieldAccessTransformer
extends AccessTransformer<FieldNode> {
    private final String fieldName;

    public FieldAccessTransformer(Target.FieldTarget target, Transformation transformation) {
        super((Target)target, transformation);
        this.fieldName = target.fieldName();
    }

    @Override
    public TargetType getType() {
        return TargetType.FIELD;
    }

    @Override
    protected void apply(FieldNode node, Set<String> privateChanged) {
        node.access = FieldAccessTransformer.mergeWith(node.access, this.getTransformation().modifier(), this.getTransformation().finalState());
    }

    @Override
    public String targetName() {
        return this.getFieldName();
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

