/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.trainingwheels.gradle.functional.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.GradleRunner;

public class Runtime
implements GroovyObject {
    private final String projectName;
    private final Map<String, String> properties;
    private final Set<String> jvmArgs;
    private final boolean usesLocalBuildCache;
    private final Map<String, String> files;
    private final Map<String, String> plugins;
    private File projectDir;
    private Runtime rootProject;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public Runtime(String projectName, Map<String, String> properties, Set<String> jvmArgs, boolean usesLocalBuildCache, Map<String, String> files, Map<String, String> plugins) {
        boolean bl;
        String string;
        MetaClass metaClass;
        HashSet hashSet;
        HashMap hashMap;
        this.properties = hashMap = Maps.newHashMap();
        this.jvmArgs = hashSet = Sets.newHashSet();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.projectName = string = projectName;
        this.usesLocalBuildCache = bl = usesLocalBuildCache;
        Map<String, String> map = files;
        this.files = map;
        this.properties.put("org.gradle.console", "rich");
        this.properties.putAll(properties);
        this.jvmArgs.addAll(jvmArgs);
        Map<String, String> map2 = plugins;
        this.plugins = map2;
    }

    private GradleRunner gradleRunner() {
        GradleRunner runner = GradleRunner.create().withPluginClasspath().withProjectDir(this.projectDir).forwardOutput();
        return runner;
    }

    public void setup(Runtime rootProject, File workspaceDirectory) {
        if (ScriptBytecodeAdapter.compareEqual((Object)rootProject, (Object)this)) {
            this.setupThisAsRoot(workspaceDirectory);
        } else {
            this.setupThisAsChild(rootProject, workspaceDirectory);
        }
    }

    private void setupThisAsChild(Runtime rootProject, File workspaceDirectory) {
        Runtime runtime;
        File file;
        this.projectDir = file = new File(workspaceDirectory, this.projectName.replace(":", "/"));
        this.projectDir.mkdirs();
        this.rootProject = runtime = rootProject;
        this.setupThis();
    }

    private void setupThisAsRoot(File workspaceDirectory) {
        Runtime runtime;
        File file;
        this.projectDir = file = workspaceDirectory;
        this.rootProject = runtime = this;
        File settingsFile = new File(this.projectDir, "settings.gradle");
        settingsFile.getParentFile().mkdirs();
        if (this.usesLocalBuildCache) {
            File localBuildCacheDirectory = new File(this.projectDir, "cache/build");
            ResourceGroovyMethods.leftShift((File)settingsFile, (Object)new GStringImpl(new Object[]{localBuildCacheDirectory.toURI()}, new String[]{"\n                buildCache {\n                    local {\n                        directory '", "'\n                    }\n                }\n            "}));
        }
        ResourceGroovyMethods.leftShift((File)settingsFile, (Object)new GStringImpl(new Object[]{this.projectName}, new String[]{"rootProject.name = '", "'"}));
        this.setupThis();
    }

    private void setupThis() {
        Set<Map.Entry<String, String>> set;
        File propertiesFile = new File(this.projectDir, "gradle.properties");
        propertiesFile.getParentFile().mkdirs();
        this.properties.put("org.gradle.jvmargs", String.join((CharSequence)" ", this.jvmArgs));
        public final class _setupThis_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setupThis_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object e) {
                return new GStringImpl(new Object[]{((Map.Entry)e).getKey(), ((Map.Entry)e).getValue()}, new String[]{"", "=", ""}).toString();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupThis_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Files.write(propertiesFile.toPath(), (Iterable<? extends CharSequence>)((Iterable)ScriptBytecodeAdapter.castToType(this.properties.entrySet().stream().map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _setupThis_closure1(this, this)), Function.class)).collect(Collectors.toList()), Iterable.class)), StandardOpenOption.CREATE_NEW);
        Reference buildGradleFile = new Reference((Object)new File(this.projectDir, "build.gradle"));
        if (!this.plugins.isEmpty()) {
            ResourceGroovyMethods.leftShift((File)((File)buildGradleFile.get()), (Object)"plugins {");
            public final class _setupThis_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference buildGradleFile;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setupThis_closure2(Object _outerInstance, Object _thisObject, Reference buildGradleFile) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.buildGradleFile = reference = buildGradleFile;
                }

                public File doCall(Object pluginId) {
                    String version = ShortTypeHandling.castToString((Object)((Runtime)this.getThisObject()).plugins.get(pluginId));
                    String line = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId}, new String[]{"   id '", "'"}));
                    if (!version.isEmpty()) {
                        line = StringGroovyMethods.plus((String)line, (CharSequence)new GStringImpl(new Object[]{version}, new String[]{" version: '", "'"}));
                    }
                    return ResourceGroovyMethods.leftShift((File)((File)ScriptBytecodeAdapter.castToType((Object)this.buildGradleFile.get(), File.class)), (Object)line);
                }

                @Generated
                public File getBuildGradleFile() {
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.buildGradleFile.get(), File.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setupThis_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            this.plugins.keySet().forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _setupThis_closure2(this, this, buildGradleFile)), Consumer.class));
            ResourceGroovyMethods.leftShift((File)((File)buildGradleFile.get()), (Object)"}");
        }
        Iterator<Map.Entry<String, String>> iterator = (set = this.files.entrySet()) != null ? set.iterator() : null;
        Map.Entry<String, String> e = null;
        Iterator<Map.Entry<String, String>> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                e = iterator2.next();
                String file = ShortTypeHandling.castToString((Object)e.getKey());
                String content = ShortTypeHandling.castToString((Object)e.getValue());
                File target = new File(this.projectDir, file);
                target.getParentFile().mkdirs();
                ResourceGroovyMethods.leftShift((File)target, (Object)content);
            }
        }
    }

    public BuildResult run(Consumer<RunBuilder> runBuilderConsumer) {
        if (this.rootProject != null && ScriptBytecodeAdapter.compareNotEqual((Object)this.rootProject, (Object)this)) {
            throw (Throwable)new IllegalStateException("Tried to run none root build!");
        }
        RunBuilder runBuilder = new RunBuilder();
        runBuilderConsumer.accept(runBuilder);
        GradleRunner runner = this.gradleRunner();
        ArrayList arguments = Lists.newArrayList(runBuilder.arguments);
        if (runBuilder.logLevel.isRequiredAsArgument) {
            DefaultGroovyMethods.addAll((Collection)arguments, (Object[])new Object[]{runBuilder.logLevel.getArgument()});
        }
        arguments.addAll(runBuilder.tasks);
        if (runBuilder.shouldFail) {
            return runner.withArguments((List)arguments).buildAndFail();
        }
        return runner.withArguments((List)arguments).build();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Runtime.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Runtime.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Runtime.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Runtime.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Runtime.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Runtime.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static class Builder
    implements GroovyObject {
        private final String projectName;
        private final Map<String, String> properties;
        private final Set<String> jvmArgs;
        private final Map<String, String> files;
        private final Map<String, String> plugins;
        private boolean usesLocalBuildCache;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Builder(String projectName) {
            String string;
            MetaClass metaClass;
            boolean bl;
            HashMap hashMap;
            HashMap hashMap2;
            HashSet hashSet;
            HashMap hashMap3;
            this.properties = hashMap3 = Maps.newHashMap();
            this.jvmArgs = hashSet = Sets.newHashSet();
            this.files = hashMap2 = Maps.newHashMap();
            this.plugins = hashMap = Maps.newHashMap();
            this.usesLocalBuildCache = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.projectName = string = projectName;
        }

        public Builder enableLocalBuildCache() {
            boolean bl;
            this.usesLocalBuildCache = bl = true;
            return this;
        }

        public Builder property(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder jvmArg(String value) {
            this.jvmArgs.add(value);
            return this;
        }

        public Builder maxMemory(String memoryNotation) {
            return this.jvmArg(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{memoryNotation}, new String[]{"-Xmx", ""})));
        }

        public Builder parallel() {
            return this.property("org.gradle.parallel", "true");
        }

        public Builder file(String path, String content) {
            this.files.put(path, content);
            return this;
        }

        public Builder build(String content) {
            return this.file("build.gradle", content);
        }

        public Builder settings(String content) {
            return this.file("settings.gradle", content);
        }

        public Builder plugin(String pluginId) {
            return this.plugin(pluginId, "");
        }

        public Builder plugin(String pluginId, String pluginVersion) {
            this.plugins.put(pluginId, pluginVersion);
            return this;
        }

        public Runtime create() {
            return new Runtime(this.projectName, this.properties, this.jvmArgs, this.usesLocalBuildCache, this.files, this.plugins);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Builder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }

    public static class RunBuilder
    implements GroovyObject {
        private LogLevel logLevel;
        private final List<String> arguments;
        private final List<String> tasks;
        private boolean shouldFail;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        private RunBuilder() {
            MetaClass metaClass;
            boolean bl;
            LogLevel logLevel;
            this.logLevel = logLevel = LogLevel.NONE;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.arguments = arrayList;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            this.tasks = arrayList2;
            this.shouldFail = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public RunBuilder log(LogLevel level) {
            LogLevel logLevel;
            this.logLevel = logLevel = level;
            return this;
        }

        public RunBuilder arguments(String ... args) {
            DefaultGroovyMethods.addAll(this.arguments, (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)));
            return this;
        }

        public RunBuilder tasks(String ... tsk) {
            DefaultGroovyMethods.addAll(this.tasks, (Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)tsk, Object[].class)));
            return this;
        }

        public RunBuilder shouldFail() {
            boolean bl;
            this.shouldFail = bl = true;
            return this;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(RunBuilder.class, Runtime.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != RunBuilder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }

    public static final class LogLevel
    extends Enum<LogLevel>
    implements GroovyObject {
        public static final /* enum */ LogLevel NONE;
        public static final /* enum */ LogLevel INFO;
        public static final /* enum */ LogLevel DEBUG;
        private final String argument;
        private final boolean isRequiredAsArgument;
        public static final LogLevel MIN_VALUE;
        public static final LogLevel MAX_VALUE;
        private static final /* synthetic */ LogLevel[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        private LogLevel(String argument) {
            String string;
            boolean bl;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)argument, (Object)"")) {
                String string2;
                boolean bl2;
                this.isRequiredAsArgument = bl2 = false;
                this.argument = string2 = "";
                return;
            }
            this.isRequiredAsArgument = bl = true;
            this.argument = string = argument;
        }

        @Generated
        private LogLevel() {
            CallSite[] callSiteArray = LogLevel.$getCallSiteArray();
            this("");
        }

        public String getArgument() {
            if (!this.isRequiredAsArgument) {
                throw (Throwable)new IllegalStateException("No argument is needed.");
            }
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.argument}, new String[]{"--", ""}));
        }

        @Generated
        public static final LogLevel[] values() {
            return (LogLevel[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), LogLevel[].class);
        }

        @Generated
        public LogLevel next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                ordinal = 0;
            }
            return (LogLevel)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), LogLevel.class);
        }

        @Generated
        public LogLevel previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                ordinal = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (LogLevel)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), LogLevel.class);
        }

        @Generated
        public static LogLevel valueOf(String name) {
            return (LogLevel)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(LogLevel.class, name)), LogLevel.class);
        }

        @Generated
        public static final /* synthetic */ LogLevel $INIT(Object ... para) {
            LogLevel logLevel;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, LogLevel.class)) {
                case -1348271900: {
                    LogLevel logLevel2;
                    logLevel = logLevel2;
                    Object[] objectArray2 = objectArray;
                    logLevel2 = new LogLevel();
                    break;
                }
                case -613992018: {
                    LogLevel logLevel2;
                    logLevel = logLevel2;
                    Object[] objectArray2 = objectArray;
                    logLevel2 = new LogLevel(ShortTypeHandling.castToString((Object)objectArray[2]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return logLevel;
        }

        static {
            LogLevel logLevel;
            LogLevel logLevel2;
            LogLevel logLevel3;
            LogLevel logLevel4;
            LogLevel logLevel5;
            NONE = logLevel5 = LogLevel.$INIT("NONE", 0);
            INFO = logLevel4 = LogLevel.$INIT("INFO", 1, "info");
            DEBUG = logLevel3 = LogLevel.$INIT("DEBUG", 2, "debug");
            MIN_VALUE = logLevel2 = NONE;
            MAX_VALUE = logLevel = DEBUG;
            LogLevel[] logLevelArray = new LogLevel[]{NONE, INFO, DEBUG};
            $VALUES = logLevelArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != LogLevel.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LogLevel.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LogLevel.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

