/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.elc.configs;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.neoforged.elc.attributes.EAttribute;
import net.neoforged.elc.attributes.EValue;
import net.neoforged.elc.attributes.PrimitiveAttribute;
import net.neoforged.elc.configs.LaunchConfig;
import net.neoforged.elc.util.Util;
import org.jetbrains.annotations.Nullable;

public final class LaunchGroup
implements LaunchConfig {
    private final List<Entry> entries;

    public LaunchGroup(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public String getType() {
        return "org.eclipse.debug.core.groups.GroupLaunchConfigurationType";
    }

    @Override
    public List<EAttribute> bakeAttributes() {
        ArrayList<EAttribute> attributes = new ArrayList<EAttribute>();
        this.entries.forEach(entry -> entry.bakeAttributes(attributes));
        return attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Entry.Builder entry(String name) {
        return new Entry.Builder(name);
    }

    public String toString() {
        return "LaunchGroup[" + "entries=" + this.entries + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(((LaunchGroup)arg0).entries, this.entries);
        {
        }
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public static class Builder {
        List<Entry> entries = new ArrayList<Entry>();

        public Builder entry(Entry.Builder entry) {
            this.entries.add(entry.build(this.entries.size()));
            return this;
        }

        public LaunchGroup build() {
            return new LaunchGroup(Util.copyOf(this.entries));
        }
    }

    public static final class Entry {
        private final int index;
        private final String name;
        private final boolean enabled;
        private final boolean adoptIfRunning;
        private final Mode mode;
        private final Action action;

        public Entry(int index, String name, boolean enabled, boolean adoptIfRunning, Mode mode, Action action) {
            this.index = index;
            this.name = name;
            this.enabled = enabled;
            this.adoptIfRunning = adoptIfRunning;
            this.mode = mode;
            this.action = action;
        }

        public void bakeAttributes(List<EAttribute> attributes) {
            attributes.add(EAttribute.of(Keys.name(this.index), this.name));
            attributes.add(EAttribute.of(Keys.enabled(this.index), this.enabled));
            if (this.adoptIfRunning) {
                attributes.add(EAttribute.of(Keys.adoptIfRunning(this.index), this.adoptIfRunning));
            }
            attributes.add(EAttribute.of(Keys.mode(this.index), this.mode));
            attributes.add(EAttribute.of(Keys.action(this.index), this.action.type));
            if (this.action.type.hasParam()) {
                attributes.add(new PrimitiveAttribute(Keys.actionParam(this.index), this.action.param));
            }
        }

        public static Builder builder(String name) {
            return new Builder(name);
        }

        public String toString() {
            return "Entry[" + "index=" + this.index + "," + "name=" + this.name + "," + "enabled=" + this.enabled + "," + "adoptIfRunning=" + this.adoptIfRunning + "," + "mode=" + (Object)((Object)this.mode) + "," + "action=" + this.action + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.index;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.enabled ? 1 : 0);
            result = 31 * result + (this.adoptIfRunning ? 1 : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((Entry)arg0).index != this.index) {
                return false;
            }
            if (!Objects.equals(((Entry)arg0).name, this.name)) {
                return false;
            }
            if (((Entry)arg0).enabled != this.enabled) {
                return false;
            }
            if (((Entry)arg0).adoptIfRunning != this.adoptIfRunning) {
                return false;
            }
            if (!Objects.equals((Object)((Entry)arg0).mode, (Object)this.mode)) {
                return false;
            }
            return Objects.equals(((Entry)arg0).action, this.action);
            {
            }
        }

        public int index() {
            return this.index;
        }

        public String name() {
            return this.name;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean adoptIfRunning() {
            return this.adoptIfRunning;
        }

        public Mode mode() {
            return this.mode;
        }

        public Action action() {
            return this.action;
        }

        public static class Builder {
            private final String name;
            private boolean enabled = true;
            private boolean adoptIfRunning = false;
            private Mode mode = Mode.INHERIT;
            private Action action = Action.NONE;

            public Builder(String name) {
                this.name = name;
            }

            public Builder enabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder adoptIfRunning(boolean adoptIfRunning) {
                this.adoptIfRunning = adoptIfRunning;
                return this;
            }

            public Builder mode(Mode mode) {
                this.mode = mode;
                return this;
            }

            public Builder action(Action action) {
                this.action = action;
                return this;
            }

            public Entry build(int index) {
                return new Entry(index, this.name, this.enabled, this.adoptIfRunning, this.mode, this.action);
            }
        }
    }

    public static class Keys {
        public static final String PREFIX = "org.eclipse.debug.core.launchGroup.";

        public static String name(int index) {
            return PREFIX + index + ".name";
        }

        public static String enabled(int index) {
            return PREFIX + index + ".enabled";
        }

        public static String adoptIfRunning(int index) {
            return PREFIX + index + ".adoptIfRunning";
        }

        public static String mode(int index) {
            return PREFIX + index + ".mode";
        }

        public static String action(int index) {
            return PREFIX + index + ".action";
        }

        public static String actionParam(int index) {
            return PREFIX + index + ".actionParam";
        }
    }

    public static enum Mode {
        INHERIT,
        RUN,
        DEBUG,
        PROFILE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static final class Action {
        private final ActionType type;
        @Nullable
        private final EValue<?> param;
        public static final Action NONE = new Action(ActionType.NONE, null);

        public Action(ActionType type, @Nullable EValue<?> param) {
            this.type = type;
            this.param = param;
        }

        public void bakeAttributes(List<EAttribute> attributes) {
            attributes.add(EAttribute.of("action", this.type));
            if (this.param != null) {
                attributes.add(new PrimitiveAttribute("actionParam", this.param));
            }
        }

        public static Action none() {
            return NONE;
        }

        public static Action waitForTermination() {
            return new Action(ActionType.WAIT_FOR_TERMINATION, null);
        }

        public static Action delay(int delay) {
            return new Action(ActionType.DELAY, EValue.of(String.valueOf(delay)));
        }

        public static Action outputRegexp(String regex) {
            return new Action(ActionType.OUTPUT_REGEXP, EValue.of(regex));
        }

        public String toString() {
            return "Action[" + "type=" + (Object)((Object)this.type) + "," + "param=" + this.param + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.param != null ? this.param.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals((Object)((Action)arg0).type, (Object)this.type)) {
                return false;
            }
            return Objects.equals(((Action)arg0).param, this.param);
            {
            }
        }

        public ActionType type() {
            return this.type;
        }

        @Nullable
        public EValue<?> param() {
            return this.param;
        }

        public static enum ActionType {
            NONE,
            WAIT_FOR_TERMINATION,
            DELAY,
            OUTPUT_REGEXP;


            public boolean hasParam() {
                return this == DELAY || this == OUTPUT_REGEXP;
            }
        }
    }
}

