/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.elc.configs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.elc.attributes.EAttribute;
import net.neoforged.elc.attributes.EValue;
import net.neoforged.elc.configs.LaunchConfig;
import net.neoforged.elc.util.Util;
import org.jetbrains.annotations.Nullable;

public final class JavaApplicationLaunchConfig
implements LaunchConfig {
    private final String project;
    private final String mainClass;
    @Nullable
    private final String moduleName;
    private final List<String> arguments;
    private final List<String> vmArguments;
    private final Map<String, String> envVars;
    @Nullable
    private final String workingDirectory;
    private final boolean stopInMain;
    @Nullable
    private final String jreContainer;
    private final List<EAttribute> extraAttributes;
    private final boolean useArgumentsFile;

    public JavaApplicationLaunchConfig(String project, String mainClass, @Nullable String moduleName, List<String> arguments, List<String> vmArguments, Map<String, String> envVars, @Nullable String workingDirectory, boolean stopInMain, @Nullable String jreContainer, List<EAttribute> extraAttributes, boolean useArgumentsFile) {
        this.project = project;
        this.mainClass = mainClass;
        this.moduleName = moduleName;
        this.arguments = arguments;
        this.vmArguments = vmArguments;
        this.envVars = envVars;
        this.workingDirectory = workingDirectory;
        this.stopInMain = stopInMain;
        this.jreContainer = jreContainer;
        this.extraAttributes = extraAttributes;
        this.useArgumentsFile = useArgumentsFile;
    }

    @Override
    public String getType() {
        return "org.eclipse.jdt.launching.localJavaApplication";
    }

    @Override
    public List<EAttribute> bakeAttributes() {
        ArrayList<EAttribute> attributes = new ArrayList<EAttribute>();
        attributes.add(EAttribute.of("org.eclipse.jdt.launching.PROJECT_ATTR", this.project));
        attributes.add(EAttribute.of("org.eclipse.jdt.launching.MAIN_TYPE", this.mainClass));
        if (this.moduleName != null) {
            attributes.add(EAttribute.of("org.eclipse.jdt.launching.MODULE_NAME", this.project));
        }
        attributes.add(EAttribute.of("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", JavaApplicationLaunchConfig.argsListToStr(this.arguments)));
        attributes.add(EAttribute.of("org.eclipse.jdt.launching.VM_ARGUMENTS", JavaApplicationLaunchConfig.argsListToStr(this.vmArguments)));
        if (this.envVars.size() > 0) {
            HashMap copy = new HashMap();
            for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
                copy.put(entry.getKey(), EValue.of(entry.getValue()));
            }
            attributes.add(EAttribute.of("org.eclipse.debug.core.environmentVariables", copy));
        }
        if (this.workingDirectory != null) {
            attributes.add(EAttribute.of("org.eclipse.jdt.launching.WORKING_DIRECTORY", this.workingDirectory));
        }
        attributes.add(EAttribute.of("org.eclipse.jdt.launching.STOP_IN_MAIN", this.stopInMain));
        if (this.jreContainer != null) {
            attributes.add(EAttribute.of("org.eclipse.jdt.launching.JRE_CONTAINER", this.jreContainer));
        }
        attributes.add(EAttribute.of("org.eclipse.jdt.launching.ATTR_ATTR_USE_ARGFILE", this.useArgumentsFile));
        attributes.addAll(this.extraAttributes);
        return attributes;
    }

    public static String argsListToStr(List<String> list) {
        return list.stream().collect(StringBuilder::new, (sb, str) -> sb.append(" ").append((String)str), (sb1, sb2) -> sb1.append(sb2.toString())).toString();
    }

    public static Builder builder(String project) {
        return new Builder(project);
    }

    public String toString() {
        return "JavaApplicationLaunchConfig[" + "project=" + this.project + "," + "mainClass=" + this.mainClass + "," + "moduleName=" + this.moduleName + "," + "arguments=" + this.arguments + "," + "vmArguments=" + this.vmArguments + "," + "envVars=" + this.envVars + "," + "workingDirectory=" + this.workingDirectory + "," + "stopInMain=" + this.stopInMain + "," + "jreContainer=" + this.jreContainer + "," + "extraAttributes=" + this.extraAttributes + "," + "useArgumentsFile=" + this.useArgumentsFile + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.mainClass != null ? this.mainClass.hashCode() : 0);
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        result = 31 * result + (this.vmArguments != null ? this.vmArguments.hashCode() : 0);
        result = 31 * result + (this.envVars != null ? this.envVars.hashCode() : 0);
        result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
        result = 31 * result + (this.stopInMain ? 1 : 0);
        result = 31 * result + (this.jreContainer != null ? this.jreContainer.hashCode() : 0);
        result = 31 * result + (this.extraAttributes != null ? this.extraAttributes.hashCode() : 0);
        result = 31 * result + (this.useArgumentsFile ? 1 : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).project, this.project)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).mainClass, this.mainClass)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).moduleName, this.moduleName)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).arguments, this.arguments)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).vmArguments, this.vmArguments)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).envVars, this.envVars)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).workingDirectory, this.workingDirectory)) {
            return false;
        }
        if (((JavaApplicationLaunchConfig)arg0).stopInMain != this.stopInMain) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).jreContainer, this.jreContainer)) {
            return false;
        }
        if (!Objects.equals(((JavaApplicationLaunchConfig)arg0).extraAttributes, this.extraAttributes)) {
            return false;
        }
        return ((JavaApplicationLaunchConfig)arg0).useArgumentsFile == this.useArgumentsFile;
        {
        }
    }

    public String project() {
        return this.project;
    }

    public String mainClass() {
        return this.mainClass;
    }

    @Nullable
    public String moduleName() {
        return this.moduleName;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public List<String> vmArguments() {
        return this.vmArguments;
    }

    public Map<String, String> envVars() {
        return this.envVars;
    }

    @Nullable
    public String workingDirectory() {
        return this.workingDirectory;
    }

    public boolean stopInMain() {
        return this.stopInMain;
    }

    @Nullable
    public String jreContainer() {
        return this.jreContainer;
    }

    public List<EAttribute> extraAttributes() {
        return this.extraAttributes;
    }

    public boolean useArgumentsFile() {
        return this.useArgumentsFile;
    }

    public static class Keys {
        public static final String LAUNCHING_PLUGIN_ID = "org.eclipse.jdt.launching";
        public static final String TYPE = "org.eclipse.jdt.launching.localJavaApplication";
        public static final String ATTR_PROJECT_NAME = "org.eclipse.jdt.launching.PROJECT_ATTR";
        public static final String ATTR_MAIN_TYPE_NAME = "org.eclipse.jdt.launching.MAIN_TYPE";
        public static final String ATTR_MODULE_NAME = "org.eclipse.jdt.launching.MODULE_NAME";
        public static final String ATTR_STOP_IN_MAIN = "org.eclipse.jdt.launching.STOP_IN_MAIN";
        public static final String ATTR_PROGRAM_ARGUMENTS = "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS";
        public static final String ATTR_VM_ARGUMENTS = "org.eclipse.jdt.launching.VM_ARGUMENTS";
        public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.jdt.launching.WORKING_DIRECTORY";
        public static final String ATTR_JRE_CONTAINER_PATH = "org.eclipse.jdt.launching.JRE_CONTAINER";
        public static final String ATTR_ENV_VARS = "org.eclipse.debug.core.environmentVariables";
        public static final String ATTR_USE_ARGFILE = "org.eclipse.jdt.launching.ATTR_ATTR_USE_ARGFILE";
    }

    public static final class Builder {
        private String project;
        @Nullable
        private String moduleName;
        List<String> arguments = new ArrayList<String>();
        List<String> vmArguments = new ArrayList<String>();
        Map<String, String> envVars = new HashMap<String, String>();
        @Nullable
        String workingDirectory;
        boolean stopInMain;
        @Nullable
        String jreContainer;
        List<EAttribute> extraAttributes = new ArrayList<EAttribute>();
        boolean useArgumentsFile = false;

        public Builder(String project) {
            this.project = project;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder moduleName(@Nullable String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder args(String ... args) {
            for (String arg : args) {
                this.arguments.add(arg);
            }
            return this;
        }

        public Builder vmArgs(String ... args) {
            for (String arg : args) {
                this.vmArguments.add(arg);
            }
            return this;
        }

        public Builder envVar(String key, String value) {
            this.envVars.put(key, value);
            return this;
        }

        public Builder envVar(Map<String, String> values) {
            this.envVars.putAll(values);
            return this;
        }

        public Builder workingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder stopInMain(boolean stopInMain) {
            this.stopInMain = stopInMain;
            return this;
        }

        public Builder jreContainer(@Nullable String jreContainer) {
            this.jreContainer = jreContainer;
            return this;
        }

        public Builder extraAttribute(EAttribute attr) {
            this.extraAttributes.add(attr);
            return this;
        }

        public Builder useArgumentsFile(boolean useArgumentsFile) {
            this.useArgumentsFile = useArgumentsFile;
            return this;
        }

        public Builder useArgumentsFile() {
            return this.useArgumentsFile(true);
        }

        public JavaApplicationLaunchConfig build(String mainClass) {
            return new JavaApplicationLaunchConfig(this.project, mainClass, this.moduleName, Util.copyOf(this.arguments), Util.copyOf(this.vmArguments), Util.copyOf(this.envVars), this.workingDirectory, this.stopInMain, this.jreContainer, Util.copyOf(this.extraAttributes), this.useArgumentsFile);
        }
    }
}

