/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.elc.attributes;

import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.elc.attributes.EAttribute;
import net.neoforged.elc.attributes.EValue;

public final class PrimitiveAttribute<T>
implements EAttribute {
    private final String key;
    private final EValue<T> value;

    public PrimitiveAttribute(String key, EValue<T> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void write(XMLStreamWriter writer, XMLOutputFactory outputFactory) throws XMLStreamException {
        writer.writeStartElement(this.value.getTypeId());
        writer.writeAttribute("key", this.key);
        writer.writeAttribute("value", this.value.serialize());
        writer.writeEndElement();
    }

    public String toString() {
        return "PrimitiveAttribute[" + "key=" + this.key + "," + "value=" + this.value + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((PrimitiveAttribute)arg0).key, this.key)) {
            return false;
        }
        return Objects.equals(((PrimitiveAttribute)arg0).value, this.value);
        {
        }
    }

    @Override
    public String key() {
        return this.key;
    }

    public EValue<T> value() {
        return this.value;
    }
}

