/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.elc.attributes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.elc.attributes.EAttribute;
import net.neoforged.elc.attributes.EValue;

public final class ListAttribute
implements EAttribute {
    private final String key;
    private final List<EValue<?>> values;

    public ListAttribute(String key) {
        this(key, new ArrayList());
    }

    public ListAttribute(String key, List<EValue<?>> values) {
        this.key = key;
        this.values = values;
    }

    @Override
    public void write(XMLStreamWriter writer, XMLOutputFactory outputFactory) throws XMLStreamException {
        writer.writeStartElement("listAttribute");
        writer.writeAttribute("key", this.key);
        writer.writeCharacters("\n");
        for (EValue<?> entry : this.values) {
            writer.writeCharacters("        ");
            writer.writeStartElement("listEntry");
            writer.writeAttribute("value", entry.serialize());
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("    ");
        writer.writeEndElement();
    }

    public String toString() {
        return "ListAttribute[" + "key=" + this.key + "," + "values=" + this.values + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((ListAttribute)arg0).key, this.key)) {
            return false;
        }
        return Objects.equals(((ListAttribute)arg0).values, this.values);
        {
        }
    }

    @Override
    public String key() {
        return this.key;
    }

    public List<EValue<?>> values() {
        return this.values;
    }
}

