/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.elc.attributes;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.elc.attributes.EValue;
import net.neoforged.elc.attributes.ListAttribute;
import net.neoforged.elc.attributes.MapAttribute;
import net.neoforged.elc.attributes.PrimitiveAttribute;
import net.neoforged.elc.attributes.SetAttribute;

public interface EAttribute {
    public void write(XMLStreamWriter var1, XMLOutputFactory var2) throws XMLStreamException;

    public String key();

    public static ListAttribute of(String key, List<EValue<?>> values) {
        return new ListAttribute(key, values);
    }

    public static SetAttribute of(String key, Set<EValue<?>> values) {
        return new SetAttribute(key, values);
    }

    public static MapAttribute of(String key, Map<String, EValue<?>> data) {
        return new MapAttribute(key, data);
    }

    public static PrimitiveAttribute<String> of(String key, String value) {
        return new PrimitiveAttribute<String>(key, EValue.of(value));
    }

    public static PrimitiveAttribute<Boolean> of(String key, boolean value) {
        return new PrimitiveAttribute<boolean>(key, EValue.of(value));
    }

    public static PrimitiveAttribute<Integer> of(String key, int value) {
        return new PrimitiveAttribute<int>(key, EValue.of(value));
    }

    public static <T extends Enum<T>> PrimitiveAttribute<T> of(String key, T value) {
        return new PrimitiveAttribute<T>(key, EValue.of(value));
    }

    public static <T> PrimitiveAttribute<T> of(String key, T value, Function<T, String> serializer) {
        return new PrimitiveAttribute<T>(key, EValue.of(value, serializer));
    }
}

