/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.neoforged.art.api.SignatureStripperConfig;
import net.neoforged.art.api.Transformer;

public class SignatureStripperTransformer
implements Transformer {
    private static final String DIGEST_SUFFIX = "-digest";
    private static final int DIGEST_SUFFIX_LENGTH = "-digest".length();

    public SignatureStripperTransformer(SignatureStripperConfig config) {
        if (config != SignatureStripperConfig.ALL) {
            throw new IllegalStateException("No other mode than ALL is currently supported.");
        }
    }

    @Override
    public Transformer.ManifestEntry process(Transformer.ManifestEntry entry) {
        Manifest manifest = new Manifest(entry.getManifest());
        boolean madeChanges = false;
        Iterator<Attributes> it = manifest.getEntries().values().iterator();
        while (it.hasNext()) {
            Attributes entryAttributes = it.next();
            if (!entryAttributes.keySet().removeIf(SignatureStripperTransformer::isDigestAttribute)) continue;
            madeChanges = true;
            if (!entryAttributes.isEmpty()) continue;
            it.remove();
        }
        if (madeChanges) {
            return Transformer.ManifestEntry.create(entry.getTime(), manifest);
        }
        return entry;
    }

    private static boolean isDigestAttribute(Object key) {
        String attributeName = key.toString();
        if (attributeName.length() <= DIGEST_SUFFIX_LENGTH) {
            return false;
        }
        return attributeName.regionMatches(true, attributeName.length() - DIGEST_SUFFIX_LENGTH, DIGEST_SUFFIX, 0, DIGEST_SUFFIX_LENGTH);
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        if (entry.getName().startsWith("META-INF/") && (entry.getName().endsWith(".RSA") || entry.getName().endsWith(".SF") || entry.getName().endsWith(".DSA") || entry.getName().endsWith(".EC"))) {
            return null;
        }
        return entry;
    }
}

