/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.art.internal.Pair;

class AsyncHelper {
    private final ExecutorService exec;

    AsyncHelper(ExecutorService exec) {
        this.exec = exec;
    }

    public <I> void consumeAll(Collection<? extends I> inputs, Function<I, String> namer, Consumer<I> consumer) {
        Function<Object, Pair> toCallable = i -> new Pair(namer.apply(i), () -> {
            consumer.accept(i);
            return null;
        });
        this.invokeAll(inputs.stream().map(toCallable).collect(Collectors.toList()));
    }

    public <I> CompletableFuture<Void> submitConsumeAll(Collection<? extends I> inputs, Function<I, String> namer, Consumer<I> consumer) {
        int futureIndex = 0;
        CompletableFuture[] futures = new CompletableFuture[inputs.size()];
        for (Object input : inputs) {
            futures[futureIndex++] = CompletableFuture.runAsync(() -> {
                try {
                    consumer.accept(input);
                }
                catch (Exception e) {
                    String inputName = (String)namer.apply(input);
                    throw new RuntimeException("Failed to execute task " + inputName, e);
                }
            }, this.exec);
        }
        return CompletableFuture.allOf(futures);
    }

    public <I, O> List<O> invokeAll(Collection<? extends I> inputs, Function<I, String> namer, Function<I, O> converter) {
        Function<Object, Pair> toCallable = i -> new Pair(namer.apply(i), () -> converter.apply(i));
        return this.invokeAll(inputs.stream().map(toCallable).collect(Collectors.toList()));
    }

    public <O> List<O> invokeAll(Collection<Pair<String, ? extends Callable<O>>> tasks) {
        ArrayList ret = new ArrayList(tasks.size());
        ArrayList<Pair<String, Future<O>>> processed = new ArrayList<Pair<String, Future<O>>>(tasks.size());
        for (Pair<String, Callable<O>> pair : tasks) {
            processed.add(new Pair<String, Future<O>>(pair.getLeft(), this.exec.submit(pair.getRight())));
        }
        for (Pair<String, Callable<Object>> pair : processed) {
            try {
                Object done = ((Future)((Object)pair.getRight())).get();
                if (done == null) continue;
                ret.add(done);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to execute task " + pair.getLeft(), e);
            }
        }
        return ret;
    }

    public <I, O> CompletableFuture<List<O>> submitInvokeAll(List<? extends I> inputs, Function<I, String> namer, Function<I, O> converter) {
        ArrayList<Object> ret = new ArrayList<Object>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            ret.add(null);
        }
        CompletableFuture[] futures = new CompletableFuture[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            int taskIndex = i;
            Object input = inputs.get(i);
            futures[i] = CompletableFuture.runAsync(() -> {
                try {
                    ret.set(taskIndex, converter.apply(input));
                }
                catch (Exception e) {
                    String inputName = (String)namer.apply(input);
                    throw new RuntimeException("Failed to execute task " + inputName, e);
                }
            }, this.exec);
        }
        return CompletableFuture.allOf(futures).thenApply(ignored -> {
            ret.removeIf(Objects::isNull);
            return ret;
        });
    }

    public <O> CompletableFuture<List<O>> submitInvokeAll(List<Pair<String, ? extends Callable<O>>> tasks) {
        ArrayList<Object> ret = new ArrayList<Object>(tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            ret.add(null);
        }
        CompletableFuture[] futures = new CompletableFuture[tasks.size()];
        for (int i = 0; i < tasks.size(); ++i) {
            int taskIndex = i;
            futures[i] = CompletableFuture.runAsync(() -> {
                try {
                    ret.set(taskIndex, ((Callable)((Pair)tasks.get(taskIndex)).getRight()).call());
                }
                catch (Exception e) {
                    String taskDescription = (String)((Pair)tasks.get(taskIndex)).getLeft();
                    throw new RuntimeException("Failed to execute task " + taskDescription, e);
                }
            }, this.exec);
        }
        return CompletableFuture.allOf(futures).thenApply(ignored -> {
            ret.removeIf(Objects::isNull);
            return ret;
        });
    }
}

