/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.api;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import net.neoforged.art.api.ClassProvider;
import net.neoforged.art.api.IdentifierFixerConfig;
import net.neoforged.art.api.SignatureStripperConfig;
import net.neoforged.art.api.SourceFixerConfig;
import net.neoforged.art.internal.EntryImpl;
import net.neoforged.art.internal.FFLineFixer;
import net.neoforged.art.internal.IdentifierFixer;
import net.neoforged.art.internal.ParameterAnnotationFixer;
import net.neoforged.art.internal.ParameterFinalFlagRemover;
import net.neoforged.art.internal.RecordFixer;
import net.neoforged.art.internal.RenamingTransformer;
import net.neoforged.art.internal.SignatureStripperTransformer;
import net.neoforged.art.internal.SourceFixer;
import net.neoforged.srgutils.IMappingFile;

public interface Transformer {
    default public ClassEntry process(ClassEntry entry) {
        return entry;
    }

    default public ManifestEntry process(ManifestEntry entry) {
        return entry;
    }

    default public ResourceEntry process(ResourceEntry entry) {
        return entry;
    }

    default public JavadoctorEntry process(JavadoctorEntry entry) {
        return entry;
    }

    default public Collection<? extends Entry> getExtras() {
        return Collections.emptyList();
    }

    public static Factory renamerFactory(IMappingFile map, boolean collectAbstractParams) {
        return ctx -> new RenamingTransformer(ctx.getClassProvider(), map, ctx.getLog(), collectAbstractParams);
    }

    public static Factory identifierFixerFactory(IdentifierFixerConfig config) {
        return ctx -> new IdentifierFixer(config);
    }

    public static Factory parameterAnnotationFixerFactory() {
        return ctx -> ParameterAnnotationFixer.INSTANCE;
    }

    public static Factory parameterFinalFlagRemoverFactory() {
        return ctx -> ParameterFinalFlagRemover.INSTANCE;
    }

    public static Factory fernFlowerLineFixerFactory(File sourceJar) {
        return ctx -> new FFLineFixer(ctx.getDebug(), sourceJar);
    }

    public static Factory recordFixerFactory() {
        return ctx -> RecordFixer.INSTANCE;
    }

    public static Factory sourceFixerFactory(SourceFixerConfig config) {
        return ctx -> new SourceFixer(config);
    }

    public static Factory signatureStripperFactory(SignatureStripperConfig config) {
        return ctx -> new SignatureStripperTransformer(config);
    }

    public static interface Context {
        public Consumer<String> getLog();

        public Consumer<String> getDebug();

        public ClassProvider getClassProvider();
    }

    public static interface Factory {
        public static Factory always(Transformer transformer) {
            Objects.requireNonNull(transformer, "transformer");
            return ctx -> transformer;
        }

        public Transformer create(Context var1);
    }

    public static interface JavadoctorEntry
    extends Entry {
        public static JavadoctorEntry create(long time, byte[] data) {
            return new EntryImpl.JavadoctorEntry(time, data);
        }
    }

    public static interface ManifestEntry
    extends Entry {
        public Manifest getManifest();

        public static ManifestEntry create(long time, byte[] data) {
            return new EntryImpl.ManifestEntry(time, data);
        }

        public static ManifestEntry create(long time, Manifest manifest) {
            return new EntryImpl.ManifestEntry(time, manifest);
        }
    }

    public static interface ResourceEntry
    extends Entry {
        public static ResourceEntry create(String name, long time, byte[] data) {
            return new EntryImpl.ResourceEntry(name, time, data);
        }
    }

    public static interface ClassEntry
    extends Entry {
        public static ClassEntry create(String name, long time, byte[] data) {
            return new EntryImpl.ClassEntry(name, time, data);
        }

        public static ClassEntry create(String cls, long time, byte[] data, int version) {
            return ClassEntry.create("META-INF/versions/" + version + '/' + cls + ".class", time, data);
        }

        public String getClassName();

        public boolean isMultiRelease();

        public int getVersion();
    }

    public static interface Entry {
        public static final long STABLE_TIMESTAMP = 946684800L;

        public long getTime();

        public String getName();

        public byte[] getData();

        public Entry process(Transformer var1);

        public static Entry ofFile(String name, long time, byte[] data) {
            if (name.endsWith(".class")) {
                return ClassEntry.create(name, time, data);
            }
            if (name.equals("META-INF/MANIFEST.MF")) {
                return ManifestEntry.create(time, data);
            }
            if (name.equals("javadoctor.json")) {
                return JavadoctorEntry.create(time, data);
            }
            return ResourceEntry.create(name, time, data);
        }
    }
}

